/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.load.StatementBuilder;
import org.jumpmind.symmetric.transform.TransformColumn;
import org.jumpmind.symmetric.transform.TransformTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedData
implements Cloneable {
    protected boolean generatedIdentityNeeded = false;
    protected StatementBuilder.DmlType targetDmlType;
    protected StatementBuilder.DmlType sourceDmlType;
    protected Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> columnsBy;
    protected Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> keysBy;
    protected TransformTable transformation;
    protected Map<String, String> sourceKeyValues;
    protected Map<String, String> oldSourceValues;
    protected Map<String, String> sourceValues;

    public TransformedData(TransformTable transformation, StatementBuilder.DmlType sourceDmlType, Map<String, String> sourceKeyValues, Map<String, String> oldSourceValues, Map<String, String> sourceValues) {
        this.transformation = transformation;
        this.targetDmlType = sourceDmlType;
        this.sourceDmlType = sourceDmlType;
        this.sourceKeyValues = sourceKeyValues;
        this.oldSourceValues = oldSourceValues;
        this.sourceValues = sourceValues;
    }

    public String getFullyQualifiedTableName() {
        return this.transformation.getFullyQualifiedTargetTableName();
    }

    public StatementBuilder.DmlType getTargetDmlType() {
        return this.targetDmlType;
    }

    public void setTargetDmlType(StatementBuilder.DmlType dmlType) {
        this.targetDmlType = dmlType;
    }

    public String getTableName() {
        return this.transformation.getTargetTableName();
    }

    public String getCatalogName() {
        return this.transformation.getTargetCatalogName();
    }

    public String getSchemaName() {
        return this.transformation.getTargetSchemaName();
    }

    public void put(TransformColumn column, String columnValue, boolean recordAsKey) {
        LinkedHashMap<String, String> columnValues;
        if (recordAsKey) {
            LinkedHashMap<String, String> keyValues;
            if (this.keysBy == null) {
                this.keysBy = new HashMap<TransformColumn.IncludeOnType, LinkedHashMap<String, String>>(2);
            }
            if ((keyValues = this.keysBy.get((Object)column.getIncludeOn())) == null) {
                keyValues = new LinkedHashMap();
                this.keysBy.put(column.getIncludeOn(), keyValues);
            }
            keyValues.put(column.getTargetColumnName(), columnValue);
        }
        if (this.columnsBy == null) {
            this.columnsBy = new HashMap<TransformColumn.IncludeOnType, LinkedHashMap<String, String>>(2);
        }
        if ((columnValues = this.columnsBy.get((Object)column.getIncludeOn())) == null) {
            columnValues = new LinkedHashMap();
            this.columnsBy.put(column.getIncludeOn(), columnValues);
        }
        columnValues.put(column.getTargetColumnName(), columnValue);
    }

    protected List<String> retrieve(Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> source, boolean getColumnNames) {
        ArrayList<String> list = new ArrayList<String>(source == null ? 0 : source.size());
        if (source != null) {
            LinkedHashMap<String, String> values = source.get((Object)TransformColumn.IncludeOnType.ALL);
            if (values != null) {
                if (getColumnNames) {
                    list.addAll(values.keySet());
                } else {
                    list.addAll(values.values());
                }
            }
            TransformColumn.IncludeOnType type = TransformColumn.IncludeOnType.DELETE;
            if (this.targetDmlType == StatementBuilder.DmlType.UPDATE && this.sourceDmlType != StatementBuilder.DmlType.DELETE) {
                type = TransformColumn.IncludeOnType.UPDATE;
            } else if (this.targetDmlType == StatementBuilder.DmlType.INSERT) {
                type = TransformColumn.IncludeOnType.INSERT;
            }
            values = source.get((Object)type);
            if (values != null) {
                if (getColumnNames) {
                    list.addAll(values.keySet());
                } else {
                    list.addAll(values.values());
                }
            }
        }
        return list;
    }

    public String[] getKeyNames() {
        List<String> list = this.retrieve(this.keysBy, true);
        return list.toArray(new String[list.size()]);
    }

    public String[] getKeyValues() {
        List<String> list = this.retrieve(this.keysBy, false);
        return list.toArray(new String[list.size()]);
    }

    public String[] getColumnNames() {
        List<String> list = this.retrieve(this.columnsBy, true);
        return list.toArray(new String[list.size()]);
    }

    public String[] getColumnValues() {
        List<String> list = this.retrieve(this.columnsBy, false);
        return list.toArray(new String[list.size()]);
    }

    public StatementBuilder.DmlType getSourceDmlType() {
        return this.sourceDmlType;
    }

    public TransformedData copy() {
        try {
            TransformedData clone = (TransformedData)this.clone();
            clone.columnsBy = this.copy(this.columnsBy);
            clone.keysBy = this.copy(this.keysBy);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public TransformTable getTransformation() {
        return this.transformation;
    }

    public void setGeneratedIdentityNeeded(boolean generatedIdentityNeeded) {
        this.generatedIdentityNeeded = generatedIdentityNeeded;
    }

    public boolean isGeneratedIdentityNeeded() {
        return this.generatedIdentityNeeded;
    }

    protected Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> copy(Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> toCopy) {
        HashMap<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> newMap = new HashMap<TransformColumn.IncludeOnType, LinkedHashMap<String, String>>(toCopy.size());
        for (TransformColumn.IncludeOnType key : toCopy.keySet()) {
            LinkedHashMap<String, String> value = toCopy.get((Object)key);
            newMap.put(key, new LinkedHashMap<String, String>(value));
        }
        return newMap;
    }

    public Map<String, String> getSourceKeyValues() {
        return this.sourceKeyValues;
    }

    public Map<String, String> getOldSourceValues() {
        return this.oldSourceValues;
    }

    public Map<String, String> getSourceValues() {
        return this.sourceValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSameKeyValues(String[] otherKeyValues) {
        String[] keyValues = this.getKeyValues();
        if (otherKeyValues != null) {
            if (keyValues == null) return false;
            if (keyValues.length != otherKeyValues.length) {
                return false;
            }
            for (int i = 0; i < otherKeyValues.length; ++i) {
                if (keyValues[i].equals(otherKeyValues[i])) continue;
                return false;
            }
            return true;
        } else {
            if (keyValues == null) return true;
            return false;
        }
    }
}

