/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.transform.ISingleValueColumnTransform;
import org.jumpmind.symmetric.transform.IgnoreColumnException;
import org.jumpmind.symmetric.transform.IgnoreRowException;
import org.jumpmind.symmetric.transform.TransformColumn;
import org.jumpmind.symmetric.transform.TransformedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableColumnTransform
implements ISingleValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "variable";
    protected static final String TS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    protected static final String DATE_PATTERN = "yyyy-MM-dd";
    protected static final String OPTION_TIMESTAMP = "system_timestamp";
    protected static final String OPTION_DATE = "system_date";
    private static final String[] OPTIONS = new String[]{"system_timestamp", "system_date"};

    @Override
    public boolean isAutoRegister() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static String[] getOptions() {
        return OPTIONS;
    }

    @Override
    public String transform(ICacheContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String value, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String varName = column.getTransformExpression();
        if (varName != null) {
            if (varName.equalsIgnoreCase(OPTION_TIMESTAMP)) {
                return DateFormatUtils.format((long)System.currentTimeMillis(), (String)TS_PATTERN);
            }
            if (varName.equalsIgnoreCase(OPTION_DATE)) {
                return DateFormatUtils.format((long)System.currentTimeMillis(), (String)DATE_PATTERN);
            }
        }
        return null;
    }
}

