/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;
import org.jumpmind.symmetric.transport.http.SelfSignedX509TrustManager;
import org.jumpmind.symmetric.transport.internal.InternalTransportManager;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportManagerFactoryBean
implements FactoryBean<ITransportManager> {
    private IParameterService parameterService;
    private IConfigurationService configurationService;

    public ITransportManager getObject() throws Exception {
        String transport = this.parameterService.getString("transport.type");
        if ("http".equalsIgnoreCase(transport)) {
            boolean allowSelfSignedCerts;
            final String httpSslVerifiedServerNames = this.parameterService.getString("https.verified.server.names");
            if (!StringUtils.isBlank((String)httpSslVerifiedServerNames)) {
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String s, SSLSession sslsession) {
                        boolean verified = false;
                        if (!StringUtils.isBlank((String)httpSslVerifiedServerNames)) {
                            if (httpSslVerifiedServerNames.equalsIgnoreCase("all")) {
                                verified = true;
                            } else {
                                String[] names;
                                for (String string : names = httpSslVerifiedServerNames.split(",")) {
                                    if (s == null || !s.equals(string.trim())) continue;
                                    verified = true;
                                    break;
                                }
                            }
                        }
                        return verified;
                    }
                });
            }
            if (allowSelfSignedCerts = this.parameterService.is("https.allow.self.signed.certs", false)) {
                HttpsURLConnection.setDefaultSSLSocketFactory(TransportManagerFactoryBean.createSelfSignedSocketFactory());
            }
            return new HttpTransportManager(this.parameterService);
        }
        if ("internal".equalsIgnoreCase(transport)) {
            return new InternalTransportManager(this.configurationService);
        }
        throw new IllegalStateException("An invalid transport type of " + transport + " was specified.");
    }

    public Class<ITransportManager> getObjectType() {
        return ITransportManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public IConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    private static SSLSocketFactory createSelfSignedSocketFactory() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLSocketFactory factory = null;
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new SelfSignedX509TrustManager(null)}, new SecureRandom());
        factory = context.getSocketFactory();
        return factory;
    }
}

