/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.model.BatchInfo;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.transport.AbstractTransportManager;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.internal.InternalIncomingTransport;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingTransport;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingWithResponseTransport;
import org.springframework.beans.factory.BeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalTransportManager
extends AbstractTransportManager
implements ITransportManager {
    static final ILog log = LogFactory.getLog(InternalTransportManager.class);
    IConfigurationService configurationService;

    public InternalTransportManager(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public IIncomingTransport getPullTransport(Node remote, final Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        final PipedOutputStream respOs = new PipedOutputStream();
        PipedInputStream respIs = new PipedInputStream(respOs);
        final ChannelMap suspendIgnoreChannels = this.configurationService.getSuspendIgnoreChannelLists(remote.getNodeId());
        this.runAtClient(remote.getSyncUrl(), null, respOs, new IClientRunnable(){

            public void run(BeanFactory factory, InputStream is, OutputStream os) throws Exception {
                IDataExtractorService extractor = (IDataExtractorService)factory.getBean("dataExtractorService");
                InternalOutgoingTransport transport = new InternalOutgoingTransport(respOs, suspendIgnoreChannels);
                extractor.extract(local, transport);
                transport.close();
            }
        });
        return new InternalIncomingTransport(respIs);
    }

    @Override
    public IOutgoingWithResponseTransport getPushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        PipedOutputStream pushOs = new PipedOutputStream();
        final PipedInputStream pushIs = new PipedInputStream(pushOs);
        final PipedOutputStream respOs = new PipedOutputStream();
        PipedInputStream respIs = new PipedInputStream(respOs);
        this.runAtClient(remote.getSyncUrl(), pushIs, respOs, new IClientRunnable(){

            public void run(BeanFactory factory, InputStream is, OutputStream os) throws Exception {
                IDataLoaderService service = (IDataLoaderService)factory.getBean("dataLoaderService");
                service.loadData(pushIs, respOs);
            }
        });
        return new InternalOutgoingWithResponseTransport(pushOs, respIs);
    }

    @Override
    public IIncomingTransport getRegisterTransport(final Node client, String registrationUrl) throws IOException {
        PipedOutputStream respOs = new PipedOutputStream();
        PipedInputStream respIs = new PipedInputStream(respOs);
        this.runAtClient(registrationUrl, null, respOs, new IClientRunnable(){

            public void run(BeanFactory factory, InputStream is, OutputStream os) throws Exception {
                IRegistrationService service = (IRegistrationService)factory.getBean("registrationService");
                service.registerNode(client, os, false);
            }
        });
        return new InternalIncomingTransport(respIs);
    }

    @Override
    public int sendAcknowledgement(Node remote, List<IncomingBatch> list, Node local, String securityToken, String registrationUrl) throws IOException {
        try {
            if (list != null && list.size() > 0) {
                ISymmetricEngine remoteEngine = this.getTargetEngine(remote.getSyncUrl());
                String ackData = this.getAcknowledgementData(local.getNodeId(), list);
                List<BatchInfo> batches = this.readAcknowledgement(ackData);
                IAcknowledgeService service = (IAcknowledgeService)remoteEngine.getApplicationContext().getBean("acknowledgeService");
                for (BatchInfo batchInfo : batches) {
                    service.ack(batchInfo);
                }
            }
            return 200;
        }
        catch (Exception ex) {
            log.error(ex);
            return -1;
        }
    }

    @Override
    public void writeAcknowledgement(OutputStream out, List<IncomingBatch> list, Node local, String securityToken) throws IOException {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out, "UTF-8"), true);
        pw.println(this.getAcknowledgementData(local.getNodeId(), list));
        pw.close();
    }

    private void runAtClient(final String url, final InputStream is, final OutputStream os, final IClientRunnable runnable) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        ISymmetricEngine engine = InternalTransportManager.this.getTargetEngine(url);
                        runnable.run((BeanFactory)engine.getApplicationContext(), is, os);
                    }
                    catch (Exception e) {
                        log.error(e);
                        Object var3_4 = null;
                        IOUtils.closeQuietly((InputStream)is);
                        IOUtils.closeQuietly((OutputStream)os);
                        return;
                    }
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly((OutputStream)os);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
        }.start();
    }

    private ISymmetricEngine getTargetEngine(String url) {
        ISymmetricEngine engine = StandaloneSymmetricEngine.findEngineByUrl(url);
        if (engine == null) {
            throw new NullPointerException("Could not find the engine reference for the following url: " + url);
        }
        return engine;
    }

    static interface IClientRunnable {
        public void run(BeanFactory var1, InputStream var2, OutputStream var3) throws Exception;
    }
}

