/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.upgrade;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.upgrade.AbstractSqlUpgradeTask;
import org.springframework.jdbc.core.RowCallbackHandler;

public class SqlDrivenUpgradeTask
extends AbstractSqlUpgradeTask {
    private static final ILog log = LogFactory.getLog(SqlDrivenUpgradeTask.class);
    protected String driverSql;
    protected String updateSql;

    public void upgrade(final String nodeId, final IParameterService parameterService, int[] fromVersion) {
        String sql = this.prepareSql(nodeId, parameterService, this.driverSql);
        log.warn("SqlForEachUpgrade", sql);
        log.warn("SqlDoUpgrade", this.updateSql);
        this.jdbcTemplate.query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                int count = rs.getMetaData().getColumnCount();
                Object[] params = new Object[count];
                for (int i = 0; i < count; ++i) {
                    params[i] = rs.getObject(i + 1);
                }
                SqlDrivenUpgradeTask.this.jdbcTemplate.update(SqlDrivenUpgradeTask.this.prepareSql(nodeId, parameterService, SqlDrivenUpgradeTask.this.updateSql), params);
            }
        });
    }

    public void setDriverSql(String driverSql) {
        this.driverSql = driverSql;
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }
}

