/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractVersion {
    final Log log = LogFactory.getLog(this.getClass());
    public static final int MAJOR_INDEX = 0;
    public static final int MINOR_INDEX = 1;
    public static final int PATCH_INDEX = 2;
    private String version = null;

    protected abstract String getPropertiesFileLocation();

    public String version() {
        if (this.version == null) {
            InputStream is = AbstractVersion.class.getResourceAsStream(this.getPropertiesFileLocation());
            if (is != null) {
                Properties p = new Properties();
                try {
                    p.load(is);
                    this.version = p.getProperty("version");
                }
                catch (IOException e) {
                    this.version = "unknown";
                    this.log.warn((Object)e, (Throwable)e);
                }
            } else {
                this.version = "development";
            }
        }
        return this.version;
    }

    public String versionWithUnderscores() {
        return this.version().replace("[\\.\\-]", "_");
    }

    public int[] parseVersion(String version) {
        version = version.replaceAll("[^0-9\\.]", "");
        int[] versions = new int[3];
        if (!StringUtils.isEmpty((String)version)) {
            String[] splitVersion = version.split("\\.");
            if (splitVersion.length >= 3) {
                versions[2] = this.parseVersionComponent(splitVersion[2]);
            }
            if (splitVersion.length >= 2) {
                versions[1] = this.parseVersionComponent(splitVersion[1]);
            }
            if (splitVersion.length >= 1) {
                versions[0] = this.parseVersionComponent(splitVersion[0]);
            }
        }
        return versions;
    }

    private int parseVersionComponent(String versionComponent) {
        int version = 0;
        try {
            version = Integer.parseInt(versionComponent);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    protected boolean isOlderMajorVersion(String version) {
        return this.isOlderMajorVersion(this.parseVersion(version));
    }

    protected boolean isOlderMajorVersion(int[] versions) {
        int[] softwareVersion = this.parseVersion(this.version());
        return versions[0] < softwareVersion[0];
    }

    public boolean isOlderVersion(String version) {
        return this.isOlderThanVersion(version, this.version());
    }

    public boolean isOlderThanVersion(String checkVersion, String targetVersion) {
        int[] targetVersions;
        if (this.noVersion(targetVersion) || this.noVersion(checkVersion)) {
            return false;
        }
        int[] checkVersions = this.parseVersion(checkVersion);
        if (checkVersions[0] < (targetVersions = this.parseVersion(targetVersion))[0]) {
            return true;
        }
        if (checkVersions[0] == targetVersions[0] && checkVersions[1] < targetVersions[1]) {
            return true;
        }
        return checkVersions[0] == targetVersions[0] && checkVersions[1] == targetVersions[1] && checkVersions[2] < targetVersions[2];
    }

    private boolean noVersion(String targetVersion) {
        return StringUtils.isBlank((String)targetVersion);
    }
}

