/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.lob.LobHandler;

public class ArgTypePreparedStatementSetter
implements PreparedStatementSetter {
    private final Object[] args;
    private final int[] argTypes;
    private final LobHandler lobHandler;

    public ArgTypePreparedStatementSetter(Object[] args, int[] argTypes, LobHandler lobHandler) {
        this.args = args;
        this.argTypes = argTypes;
        this.lobHandler = lobHandler;
    }

    public void setValues(PreparedStatement ps) throws SQLException {
        for (int i = 1; i <= this.args.length; ++i) {
            Object arg = this.args[i - 1];
            int argType = this.argTypes[i - 1];
            if (argType == 2004 && this.lobHandler != null) {
                this.lobHandler.getLobCreator().setBlobAsBytes(ps, i, (byte[])arg);
                continue;
            }
            if (argType == 2005 && this.lobHandler != null) {
                this.lobHandler.getLobCreator().setClobAsString(ps, i, (String)arg);
                continue;
            }
            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)argType, (Object)arg);
        }
    }

    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters((Object[])this.args);
    }
}

