/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParameterParser {
    private static final String IGNORE_COMMENT = "#";
    private static final String COMMENT = "# ";
    private static final String DATABASE_OVERRIDABLE = "DatabaseOverridable:";
    private static final String TAGS = "Tags:";
    private static final String TYPE = "Type:";
    final ILog log = LogFactory.getLog(this.getClass());

    public Map<String, ParameterMetaData> parse() {
        TreeMap<String, ParameterMetaData> metaData = new TreeMap<String, ParameterMetaData>();
        try {
            List lines = IOUtils.readLines((InputStream)this.getClass().getResourceAsStream("/symmetric-default.properties"));
            ParameterMetaData currentMetaData = new ParameterMetaData();
            for (String line : lines) {
                if (line.trim().startsWith(COMMENT) && line.length() > 1) {
                    if ((line = line.substring(line.indexOf(COMMENT) + 1)).contains(DATABASE_OVERRIDABLE)) {
                        currentMetaData.setDatabaseOverridable(Boolean.parseBoolean(line.substring(line.indexOf(DATABASE_OVERRIDABLE) + DATABASE_OVERRIDABLE.length()).trim()));
                        continue;
                    }
                    if (line.contains(TAGS)) {
                        String[] tags;
                        for (String tag : tags = line.substring(line.indexOf(TAGS) + TAGS.length()).trim().split(",")) {
                            currentMetaData.addTag(tag.trim());
                        }
                        continue;
                    }
                    if (line.contains(TYPE)) {
                        String type = line.substring(line.indexOf(TYPE) + TYPE.length());
                        currentMetaData.setType(type.trim());
                        continue;
                    }
                    currentMetaData.appendDescription(line);
                    continue;
                }
                if (line.trim().startsWith(IGNORE_COMMENT) || !line.contains("=")) continue;
                String key = line.substring(0, line.indexOf("="));
                String defaultValue = line.substring(line.indexOf("=") + 1);
                currentMetaData.setKey(key);
                currentMetaData.setDefaultValue(defaultValue);
                metaData.put(key, currentMetaData);
                currentMetaData = new ParameterMetaData();
            }
        }
        catch (IOException e) {
            this.log.error(e);
        }
        return metaData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParameterMetaData
    implements Serializable {
        public static final String TYPE_BOOLEAN = "boolean";
        public static final String TYPE_INT = "integer";
        private static final long serialVersionUID = 1L;
        private String key;
        private String description;
        private Set<String> tags = new HashSet<String>();
        private boolean databaseOverridable;
        private String defaultValue;
        private String type = "";

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public void setTags(Set<String> tags) {
            this.tags = tags;
        }

        public boolean isDatabaseOverridable() {
            return this.databaseOverridable;
        }

        public void setDatabaseOverridable(boolean databaseOverridable) {
            this.databaseOverridable = databaseOverridable;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void appendDescription(String value) {
            this.description = this.description == null ? value : this.description + value;
        }

        public boolean isBooleanType() {
            return this.type != null && this.type.equals(TYPE_BOOLEAN);
        }

        public boolean isIntType() {
            return this.type != null && this.type.equals(TYPE_INT);
        }

        public void addTag(String tag) {
            this.tags.add(tag);
        }
    }
}

