/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.util;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.firebirdsql.jdbc.FBDriver;
import org.firebirdsql.jdbc.FirebirdConnection;

public class MessageDump {
    private static final int ISC_CODE = 0x14000000;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String specialSaveChars = "=: \t\r\n\f#!";

    private static FirebirdConnection getConnection(String database) throws Exception {
        Class.forName(FBDriver.class.getName());
        String url = "jdbc:firebirdsql:" + database;
        return (FirebirdConnection)DriverManager.getConnection(url, "SYSDBA", "masterkey");
    }

    private static int getErrorCode(int code, int number) {
        return 0x14000000 | (code & 0x1F) << 16 | number & 0x3FFF;
    }

    private static String extractMessage(String fbMessage) {
        char[] chars = fbMessage.toCharArray();
        StringBuffer sb = new StringBuffer();
        int counter = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '%') {
                if (chars[++i] == 's') {
                    sb.append('{').append(counter++).append('}');
                    continue;
                }
                if (chars[i] == 'd') {
                    sb.append('{').append(counter++).append('}');
                    continue;
                }
                if (chars[i] == 'l') {
                    if (chars[++i] == 'd') {
                        sb.append('{').append(counter++).append('}');
                        continue;
                    }
                    sb.append("%ld");
                    continue;
                }
                sb.append('%').append(chars[i]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties extractProperties(FirebirdConnection connection) throws Exception {
        Properties result = new Properties();
        Statement stmt = connection.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT fac_code, number, text FROM messages");
            while (rs.next()) {
                int code = rs.getInt(1);
                int number = rs.getInt(2);
                String message = rs.getString(3);
                result.setProperty(Integer.toString(MessageDump.getErrorCode(code, number)), MessageDump.extractMessage(message));
            }
        }
        finally {
            stmt.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            args = new String[]{"localhost:c:/database/messages.fdb"};
        }
        FirebirdConnection connection = MessageDump.getConnection(args[0]);
        try {
            Properties props = MessageDump.extractProperties(connection);
            TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(props);
            MessageDump.store(sortedMap, new FileOutputStream("./error.properties"), "");
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Map map, OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            MessageDump.writeln(awriter, "#" + header);
        }
        MessageDump.writeln(awriter, "#" + new Date().toString());
        Map map2 = map;
        synchronized (map2) {
            for (Map.Entry entry : map.entrySet()) {
                String key = MessageDump.saveConvert((String)entry.getKey(), true);
                String val = MessageDump.saveConvert((String)entry.getValue(), false);
                MessageDump.writeln(awriter, key + "=" + val);
            }
        }
        awriter.flush();
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(MessageDump.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(MessageDump.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(MessageDump.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(MessageDump.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

