/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.beans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import rs.tetrabyte.datarest.annotation.Repository;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.beans.DocumentSum;
import rs.tetrabyte.pezar.beans.EntityLink;
import rs.tetrabyte.pezar.beans.annotations.RestLink;

@Repository(rel="documents", singleton=false)
public class Document
extends AbstractEntity {
    @RestLink(name="party")
    private List<EntityLink> parties = new ArrayList();
    @RestLink(name="inventory")
    private List<EntityLink> inventories = new ArrayList();
    private List<DocumentSum> summary = new ArrayList();
    private int status;

    public List<EntityLink> getParties() {
        return this.parties;
    }

    public void setParties(List<EntityLink> parties) {
        this.parties = parties;
    }

    public List<EntityLink> getInventories() {
        return this.inventories;
    }

    public void setInventories(List<EntityLink> inventories) {
        this.inventories = inventories;
    }

    public List<DocumentSum> getSummary() {
        return this.summary;
    }

    public void setSummary(List<DocumentSum> summary) {
        this.summary = summary;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public BigDecimal getSum(String name) {
        return this.getSummary().stream().filter(s -> s.getName().equals(name)).map(DocumentSum::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find document sum with name " + name));
    }

    public DocumentSum findSum(String name) {
        return this.getSummary().stream().filter(s -> s.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find document sum with name " + name));
    }
}

