/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.commands;

import javafx.scene.Node;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pezar.commands.DisplayContent;
import rs.tetrabyte.pezar.commands.UICommand;
import rs.tetrabyte.pezar.custom.screen.Screen;

public class DisplayContent
extends UICommand {
    @Autowired
    private Screen screen;
    public static final String NAME = "display-content";
    private Node content;
    private TargetContainer target = TargetContainer.Screen;
    private boolean singleton = false;
    private boolean closable = true;
    private Callback<Void, Void> callback;

    DisplayContent() {
    }

    public DisplayContent content(Node content) {
        this.content = content;
        return this;
    }

    public String getName() {
        return NAME;
    }

    public DisplayContent in(TargetContainer target) {
        this.target = target;
        return this;
    }

    public DisplayContent asSingleton() {
        this.singleton = true;
        return this;
    }

    public DisplayContent closable(boolean closable) {
        this.closable = closable;
        return this;
    }

    public DisplayContent withCallback(Callback<Void, Void> callback) {
        this.callback = callback;
        return this;
    }

    public Node getContent() {
        return this.content;
    }

    public TargetContainer getTarget() {
        return this.target;
    }

    public boolean isSingletonContent() {
        return this.singleton;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public Callback<Void, Void> getCallback() {
        return this.callback;
    }

    void validate() {
        String messages = "";
        if (this.content == null) {
            messages = String.valueOf(messages) + "Content can't be null. ";
        }
        if (this.target == null) {
            messages = String.valueOf(messages) + "Target container can't be null. ";
        }
        if (!StringUtils.isEmpty((CharSequence)messages)) {
            throw new IllegalArgumentException(messages);
        }
    }

    public void execute() {
        super.execute(false);
        this.screen.displayContent(this);
    }

    public String toString() {
        return String.valueOf(super.toString()) + String.format("[ %s, target container: %s ]", this.content, this.target.name());
    }
}

