/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.config;

import com.google.common.eventbus.EventBus;
import java.lang.reflect.Field;
import java.util.Optional;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.MethodParameter;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLTaskFactory;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.AcceleratorService;
import rs.tetrabyte.pezar.context.AppService;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.context.EBrowserContext;
import rs.tetrabyte.pezar.context.FocusService;
import rs.tetrabyte.pezar.context.InventoryPickerService;
import rs.tetrabyte.pezar.context.LogInService;
import rs.tetrabyte.pezar.context.MessageService;
import rs.tetrabyte.pezar.context.ModuleService;
import rs.tetrabyte.pezar.context.ParameterService;
import rs.tetrabyte.pezar.context.ReportingService;
import rs.tetrabyte.pezar.context.StockService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.context.UIFeatureService;
import rs.tetrabyte.pezar.context.UiSettingService;
import rs.tetrabyte.pezar.context.UserService;
import rs.tetrabyte.pezar.custom.factory.form.controller.FormFieldControllerFactory;
import rs.tetrabyte.pezar.custom.picker.PickerFactory;
import rs.tetrabyte.pezar.custom.screen.Screen;
import rs.tetrabyte.pezar.factory.ButtonFactory;
import rs.tetrabyte.pezar.factory.SubScreenFactory;
import rs.tetrabyte.pezar.features.UIFeatureFactory;
import rs.tetrabyte.pezar.rest.UIDescriptorReader;
import rs.tetrabyte.pezar.settings.LocalSettingsManager;
import rs.tetrabyte.pezar.websocket.WebSocketService;

@Configuration
public class PezarFXConfiguration
implements ApplicationContextAware {
    @Autowired
    private EventBus eventBus;
    private ApplicationContext applicationContext;

    private <T> T withEventBus(T object) {
        this.eventBus.register(object);
        return object;
    }

    @Bean
    public UserService provideUserService() {
        return new UserService();
    }

    @Bean
    public LogInService provideLoginService() {
        return new LogInService();
    }

    @Bean
    public UIDescriptorReader provideUIDescriptionReader(RestTaskFactory factory) {
        return new UIDescriptorReader(factory);
    }

    @Bean
    public EventBus provideEventBus() {
        return new EventBus();
    }

    @Bean
    public UICommands provideUICommands(EventBus eventBus) {
        return new UICommands(eventBus, this.applicationContext.getAutowireCapableBeanFactory());
    }

    @Bean
    public EBrowserContext provideBrowserContext() {
        return (EBrowserContext)this.withEventBus((Object)new EBrowserContext());
    }

    @Bean
    public AcceleratorService provideAcceleratorService() {
        return new AcceleratorService();
    }

    @Bean
    public FocusService provideFocusService() {
        return new FocusService();
    }

    @Bean
    public Scene provideScene(Screen screen, AcceleratorService acceleratorService, FocusService focusService) {
        Scene scene = new Scene((Parent)screen);
        acceleratorService.setScene(scene);
        focusService.setScene(scene);
        return scene;
    }

    @Bean
    public Screen provideScreen(SubScreenFactory subScreenFactory, AcceleratorService acceleratorService, FocusService focusService) {
        Screen screen = new Screen(subScreenFactory, acceleratorService, focusService);
        return (Screen)this.withEventBus((Object)screen);
    }

    @Bean
    public SubScreenFactory provideSubScreenFactory(LocaleContext localeContext, UiSettingService uiSettingService) {
        return new SubScreenFactory(localeContext, uiSettingService);
    }

    @Bean
    public UIFeatureFactory provideUIFeatureFactory(EBrowserContext browserContext) {
        return new UIFeatureFactory();
    }

    @Bean
    public UiSettingService provideUiSettingsService(RestTaskFactory rest) {
        return new UiSettingService(rest);
    }

    @Bean
    public FormFieldControllerFactory provideFormFieldControllerFactory() {
        return new FormFieldControllerFactory(this.applicationContext.getAutowireCapableBeanFactory());
    }

    @Bean
    public PickerFactory providePickerFactory() {
        return new PickerFactory(this.applicationContext.getAutowireCapableBeanFactory());
    }

    @Bean
    public TenantContext provideTenantContext() {
        return new TenantContext();
    }

    @Bean
    AppService provideAppContext(LocaleContext localeContext, UICommands uiCommands, FXMLTaskFactory fxmlTaskFactory, Scene scene) {
        return (AppService)this.withEventBus((Object)new AppService());
    }

    @Bean
    public LocalSettingsManager provideLocalSettingsManager() {
        return new LocalSettingsManager();
    }

    @Bean
    public WebSocketService provideWebSocket() {
        return (WebSocketService)this.withEventBus((Object)new WebSocketService());
    }

    @Bean
    public ButtonFactory provideButtonFactory() {
        return new ButtonFactory();
    }

    @Bean
    public InventoryPickerService provideInventoryPickerService() {
        return new InventoryPickerService();
    }

    @Bean
    public ModuleService provideModuleService(LocaleContext localeContext) {
        return (ModuleService)this.withEventBus((Object)new ModuleService(this.applicationContext, localeContext));
    }

    @Bean
    public UIFeatureService provideUIFeatureService() {
        return new UIFeatureService();
    }

    @Bean
    public MessageService provideMessageService(LocaleContext localeCtx) {
        return new MessageService(localeCtx);
    }

    @Bean
    public ControlsFactoryService provideControlsFactoryService() {
        return new ControlsFactoryService();
    }

    @Bean
    public ReportingService provideReportingService() {
        return new ReportingService();
    }

    @Bean
    public ParameterService provideParameterService() {
        return new ParameterService();
    }

    @Bean
    public StockService provideStockService() {
        return new StockService();
    }

    @Bean
    @Scope(value="prototype")
    public Logger logger(InjectionPoint ip) {
        return LoggerFactory.getLogger((Class)Optional.ofNullable(ip.getField()).map(Field::getDeclaringClass).orElseGet(() -> Optional.ofNullable(ip.getMethodParameter()).map(MethodParameter::getContainingClass).orElseThrow(IllegalArgumentException::new)));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

