/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.hateoas.Resources;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.context.ModuleService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.context.UIFeatureService;
import rs.tetrabyte.pezar.features.UIFeature;
import rs.tetrabyte.pezar.features.UIFeatureProvider;
import rs.tetrabyte.pezar.fxml.factory.LocaleContextImpl;

public class ModuleService {
    @Autowired
    Logger logger;
    @Autowired
    private TenantContext tenantContext;
    @Autowired
    private RestTaskFactory factory;
    @Autowired
    private UIFeatureService featureService;
    private ApplicationContext parentContext;
    private AnnotationConfigApplicationContext childContext;
    private LocaleContextImpl localeContext;
    private GroovyClassLoader groovyClassLoader;
    private List<Class<?>> classRegister;

    public ModuleService(ApplicationContext applicationContext, LocaleContext localeContext) {
        this.parentContext = applicationContext;
        this.localeContext = (LocaleContextImpl)localeContext;
    }

    public void initModules() {
        this.tenantContext.getActiveResident().ifPresent(resident -> {
            if (!resident.hasLink("modules")) {
                return;
            }
            this.featureService.setFetching(true);
            this.factory.createTask(client -> {
                String modulesRoot = String.valueOf(resident.getLink("modules").getHref()) + "/";
                try {
                    Collection modules = resident.getRelatedEntities("modules", Resident.Module.class);
                    ArrayList<String> messages = new ArrayList<String>();
                    for (Resident.Module module2 : modules) {
                        Resources locales;
                        if (!module2.hasLink("locales") || (locales = module2.getRelatedResources("locales", Resident.Resource.class)).getContent().size() <= 0) continue;
                        messages.add(locales.getLink("messages").getHref());
                    }
                    this.localeContext.setModuleMessageLocations(messages);
                    ArrayList classesList = new ArrayList();
                    modules.stream().map(module -> module.getClasses()).forEach(l -> {
                        boolean bl = classesList.addAll(l);
                    });
                    this.logger.info("Initializing modules [resident = {}, url = {}]", (Object)resident.getResidentId(), (Object)modulesRoot);
                    this.groovyClassLoader = new GroovyClassLoader((java.lang.ClassLoader)new ClassLoader(new URL[]{new URL(modulesRoot)}, classesList));
                    ArrayList classes = new ArrayList();
                    classesList.forEach(clazz -> {
                        try {
                            this.logger.debug("Loading Groovy class: {}", clazz);
                            Class beanType = this.groovyClassLoader.parseClass(new GroovyCodeSource(new URL(String.valueOf(modulesRoot) + clazz)));
                            classes.add(beanType);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                    this.groovyClassLoader.close();
                    return classes;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Error initializing modules [url = " + modulesRoot + "]", e);
                }
            }).whenDone(classes -> {
                List<Class> filtered;
                if (this.childContext != null) {
                    this.childContext.close();
                }
                if ((filtered = classes.stream().filter(arg_0 -> this.shouldRegisterBean(arg_0)).collect(Collectors.toList())).size() > 0) {
                    this.childContext = new AnnotationConfigApplicationContext();
                    this.childContext.setParent(this.parentContext);
                    this.childContext.register(filtered.toArray(new Class[filtered.size()]));
                    this.childContext.refresh();
                    this.runModules();
                }
                this.featureService.setFetching(false);
                this.classRegister = classes;
            }).lockUI(false).execute();
        });
    }

    public void runModules() {
        if (this.childContext != null) {
            this.childContext.getBeansOfType(UIFeatureProvider.class).entrySet().forEach(entry -> {
                UIFeatureProvider p = (UIFeatureProvider)entry.getValue();
                UIFeature feature = p.getFeature();
                ArrayList features = new ArrayList();
                this.collectFeatures(feature, features);
                this.featureService.registerFeatures(features);
            });
        }
    }

    private void collectFeatures(UIFeature feature, List<UIFeature> features) {
        if (feature.getChildren().size() == 0) {
            features.add(feature);
        } else {
            features.add(feature);
            feature.getChildren().forEach(child -> this.collectFeatures(child, features));
            feature.getChildren().clear();
        }
    }

    private boolean shouldRegisterBean(Class<?> beanType) {
        return beanType != null && (AnnotatedElementUtils.hasAnnotation(beanType, Service.class) || AnnotatedElementUtils.hasAnnotation(beanType, Component.class));
    }

    public Optional<Class<?>> getClass(Predicate<Class<?>> type) {
        return this.classRegister.stream().filter(type).findFirst();
    }
}

