/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.pezar.beans.Inventory;
import rs.tetrabyte.pezar.beans.Item;
import rs.tetrabyte.pezar.beans.Stock;
import rs.tetrabyte.task.TaskFactory;
import rs.tetrabyte.task.UIAccessor;

public class StockService {
    @Autowired
    private TaskFactory taskFactory;
    @Autowired
    private RestClient client;

    public Optional<Stock> getStock(Inventory inventory, Item item) {
        Assert.notNull((Object)item, (String)"Item can't be null");
        Assert.notNull((Object)inventory, (String)"Inventory can't be null");
        String inventoryId = inventory.parseId();
        String itemId = item.parseId();
        String stockLink = this.client.pathBuilder().base().slash("core").slash("stocks").slash(String.valueOf(inventoryId) + "-" + itemId).get();
        return Optional.ofNullable((Stock)this.client.getSingle(stockLink, Stock.class));
    }

    public void getStock(Inventory inventory, Item item, UIAccessor uiAccessor, Consumer<Stock> stock) {
        if (uiAccessor != null) {
            uiAccessor.lockUI();
        }
        this.taskFactory.createTask(() -> this.getStock(inventory, item)).whenDone(s -> {
            if (uiAccessor != null) {
                uiAccessor.unlockUI();
            }
            s.ifPresent(stock::accept);
        }).execute();
    }

    public void getStock(Inventory inventory, Item item, Consumer<Stock> stock) {
        this.getStock(inventory, item, null, stock);
    }
}

