/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.FlowPane;
import javafx.stage.FileChooser;
import javax.annotation.PostConstruct;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;

@FXMLView(value="/fxml/ReportView.fxml")
public class ReportViewController
extends FXMLController {
    @FXML
    private ImageView view;
    @FXML
    private ScrollPane viewScroll;
    @FXML
    private FlowPane viewPane;
    @FXML
    private Label lblCurrentPage;
    @FXML
    private Label lblTotalPages;
    @FXML
    private Button btnNextPage;
    @FXML
    private Button btnPrevPage;
    @Input
    private JasperPrint report;
    @Input
    private JasperReportsContext context;
    private IntegerProperty currentPage = new SimpleIntegerProperty(0);
    private float zoomRatio = 1.25f;

    @FXML
    public void onPrint() {
        try {
            JasperPrintManager.getInstance((JasperReportsContext)this.context).print(this.report, true);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onPrevPage() {
        this.currentPage.set(this.currentPage.get() - 1);
        this.view.setImage(this.printPageToImage(this.currentPage.get(), this.zoomRatio));
    }

    @FXML
    public void onNextPage() {
        new KeyCodeCombination(KeyCode.PAGE_DOWN, new KeyCombination.Modifier[0]);
        this.currentPage.set(this.currentPage.get() + 1);
        this.view.setImage(this.printPageToImage(this.currentPage.get(), this.zoomRatio));
    }

    @FXML
    public void onZoomIn() {
        this.zoomRatio += 0.25f;
        this.view.setImage(this.printPageToImage(this.currentPage.get(), this.zoomRatio));
    }

    @FXML
    public void onZoomOut() {
        this.zoomRatio -= 0.25f;
        this.view.setImage(this.printPageToImage(this.currentPage.get(), this.zoomRatio));
    }

    @FXML
    public void onSave() {
        if (this.report == null) {
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setInitialDirectory(new File("."));
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("PDF", new String[]{"*.pdf"}), new FileChooser.ExtensionFilter("HTML", new String[]{"*.html"})});
        try {
            Class.forName("org.apache.poi.POIDocument");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("DOCX", new String[]{"*.docx"}), new FileChooser.ExtensionFilter("ODT", new String[]{"*.odt"}), new FileChooser.ExtensionFilter("XLS", new String[]{"*.xls"}), new FileChooser.ExtensionFilter("XLSX", new String[]{"*.xlsx"}), new FileChooser.ExtensionFilter("ODS", new String[]{"*.ods"}), new FileChooser.ExtensionFilter("PPTX", new String[]{"*.pptx"})});
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = chooser.showSaveDialog(this.getRootNode(Node.class).getScene().getWindow());
        if (file == null) {
            return;
        }
        FileChooser.ExtensionFilter filter = chooser.getSelectedExtensionFilter();
        String ext = ((String)filter.getExtensions().get(0)).replace("*", "");
        String fileName = file.getAbsolutePath();
        if (!fileName.matches("(?i).*\\" + ext)) {
            fileName = String.valueOf(fileName) + ext;
        }
        if (this.report == null) {
            return;
        }
        try {
            switch (fileName.replaceAll(".*\\.", "").toLowerCase()) {
                case "pdf": {
                    JasperExportManager.getInstance((JasperReportsContext)this.context).exportToPdfFile(this.report, fileName);
                    break;
                }
                case "docx": {
                    this.exportToStream((Exporter)new JRDocxExporter(this.context), this.report, fileName);
                    break;
                }
                case "odt": {
                    this.exportToStream((Exporter)new JROdtExporter(this.context), this.report, fileName);
                    break;
                }
                case "xls": {
                    this.exportToStream((Exporter)new JRXlsExporter(this.context), this.report, fileName);
                    break;
                }
                case "xlsx": {
                    this.exportToStream((Exporter)new JRXlsxExporter(this.context), this.report, fileName);
                    break;
                }
                case "ods": {
                    this.exportToStream((Exporter)new JROdsExporter(this.context), this.report, fileName);
                    break;
                }
                case "pptx": {
                    this.exportToStream((Exporter)new JRPptxExporter(this.context), this.report, fileName);
                    break;
                }
                case "html": {
                    JasperExportManager.getInstance((JasperReportsContext)this.context).exportToHtmlFile(this.report, fileName);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported file type: " + fileName);
                }
            }
        }
        catch (JRException ex) {
            throw new RuntimeException("Export report failed", ex);
        }
    }

    @PostConstruct
    private void initView() {
        this.viewScroll.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.PAGE_DOWN) {
                e.consume();
                this.btnNextPage.fire();
            } else if (e.getCode() == KeyCode.PAGE_UP) {
                e.consume();
                this.btnPrevPage.fire();
            }
        });
        this.lblCurrentPage.textProperty().bind((ObservableValue)this.currentPage.add(1).asString());
        this.lblTotalPages.setText(String.valueOf(this.report.getPages().size()));
        this.btnPrevPage.disableProperty().bind((ObservableValue)this.currentPage.isEqualTo(0));
        this.btnNextPage.disableProperty().bind((ObservableValue)this.currentPage.subtract(this.report.getPages().size() - 1).isEqualTo(0));
        this.viewScroll.viewportBoundsProperty().addListener((v, o, n) -> {
            this.viewPane.setPrefWidth(n.getWidth());
            this.viewPane.setPrefHeight(n.getHeight());
        });
        this.view.setImage(this.printPageToImage(0, this.zoomRatio));
        this.view.requestFocus();
    }

    public Image printPageToImage(int pageIndex, float zoom) {
        if (this.report.getPages().size() == 0) {
            return null;
        }
        PrintPageFormat pageFormat = this.report.getPageFormat(pageIndex);
        int width = (int)Math.ceil((float)pageFormat.getPageWidth().intValue() * zoom);
        int height = (int)Math.ceil((float)pageFormat.getPageHeight().intValue() * zoom);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, width, height);
        try {
            try {
                JRGraphics2DExporter exporter = new JRGraphics2DExporter(this.context);
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.report));
                SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
                output.setGraphics2D(graphics);
                exporter.setExporterOutput((ExporterOutput)output);
                SimpleGraphics2DReportConfiguration configuration = new SimpleGraphics2DReportConfiguration();
                configuration.setPageIndex(Integer.valueOf(pageIndex));
                configuration.setZoomRatio(Float.valueOf(zoom));
                exporter.setConfiguration((ReportExportConfiguration)configuration);
                exporter.exportReport();
            }
            catch (JRException ex) {
                throw new RuntimeException("Print page failed", ex);
            }
        }
        finally {
            graphics.dispose();
        }
        return SwingFXUtils.toFXImage((BufferedImage)image, null);
    }

    private void exportToStream(Exporter<ExporterInput, ?, ?, OutputStreamExporterOutput> exporter, JasperPrint report, String fileName) throws JRException {
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(report));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(fileName));
        exporter.exportReport();
    }
}

