/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser;

import java.util.Collection;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.beans.Inventory;
import rs.tetrabyte.pezar.beans.Item;
import rs.tetrabyte.pezar.beans.Stock;
import rs.tetrabyte.pezar.controller.browser.EBrowserTablePerspectiveController;
import rs.tetrabyte.pezar.custom.EntityTreeItem;
import rs.tetrabyte.pezar.custom.factory.treeTable.TreeTableColumnFactory;

@FXMLView(value="/fxml/browser/EBrowserTablePerspective.fxml")
public class ItemBrowserTablePerspectiveController
extends EBrowserTablePerspectiveController {
    @Autowired
    private LocaleContext locale;
    @Input
    private Inventory inventory;
    @Input
    private EBrowserDescriptor descriptor;
    @Input
    private RepositoryFX<Item> repository;

    @PostConstruct
    protected void createColumns() {
        super.createColumns();
        if (this.inventory == null) {
            return;
        }
        this.descriptor.getDirective("hasQty").ifPresent(directive -> {
            if (Boolean.valueOf(directive.getValue()).booleanValue()) {
                TreeTableColumn qtyTotal = new TreeTableColumn(this.locale.getMessage("lbl.quantity", new Object[0]));
                qtyTotal.setId("col-qty-total");
                qtyTotal.setCellValueFactory(param -> ((Item)param.getValue().getValue()).getStock().qtyTotalProperty());
                qtyTotal.setCellFactory(column -> TreeTableColumnFactory.createCell((String)"decimal", null));
                TreeTableColumn qtyAllocated = new TreeTableColumn(this.locale.getMessage("lbl.quantity-allocated", new Object[0]));
                qtyAllocated.setId("col-qty-allocated");
                qtyAllocated.setCellFactory(column -> TreeTableColumnFactory.createCell((String)"decimal", null));
                qtyAllocated.setCellValueFactory(param -> ((Item)param.getValue().getValue()).getStock().qtyAllocatedProperty());
                this.getTableView().getColumns().addAll((Object[])new TreeTableColumn[]{qtyTotal, qtyAllocated});
            }
        });
        this.descriptor.getDirective("hasPrice").ifPresent(directive -> {
            if (Boolean.valueOf(directive.getValue()).booleanValue()) {
                TreeTableColumn sellPrice = new TreeTableColumn(this.locale.getMessage("lbl.price", new Object[0]));
                sellPrice.setId("col-sell-price");
                sellPrice.setCellFactory(column -> TreeTableColumnFactory.createCell((String)"decimal", null));
                sellPrice.setCellValueFactory(param -> ((Item)param.getValue().getValue()).getStock().sellPriceProperty());
                this.getTableView().getColumns().addAll((Object[])new TreeTableColumn[]{sellPrice});
            }
        });
    }

    @PostConstruct
    protected void configureInsert() {
        this.repository.addEventFilter(RepositoryFXEvent.INSERT_OK, e -> {
            Item i = (Item)e.getValue();
            i.setStock(new Stock());
            EntityTreeItem itm = new EntityTreeItem((AbstractEntity)i, this.childrenResolver);
            this.restTaskFactory.createTask(client -> (Item)client.getSingle(((AbstractEntity)itm.getValue()).getLink("parent"), this.repository.getEntityClass())).whenDone(entity -> {
                if (entity != null) {
                    EntityTreeItem parent = (EntityTreeItem)this.findItem((AbstractEntity)entity, (Collection)this.getTableView().getRoot().getChildren());
                    if (parent != null) {
                        parent.addChild(itm);
                        parent.setExpanded(true);
                    }
                } else {
                    this.getTableView().getRoot().getChildren().add((Object)itm);
                    this.getTableView().getSelectionModel().select((Object)itm);
                }
            }).execute();
        });
    }

    @PostConstruct
    protected void configureUpdate() {
        this.repository.addEventFilter(RepositoryFXEvent.UPDATE_OK, e -> {
            TreeItem item = this.findItem((AbstractEntity)e.getValue(), (Collection)this.getTableView().getRoot().getChildren());
            if (item != null) {
                Item i = (Item)e.getValue();
                i.setStock(((Item)item.getValue()).getStock());
                item.setValue((Object)i);
            }
        });
    }

    @PostConstruct
    protected void configureRefresh() {
        this.repository.addEventFilter(RepositoryFXEvent.REFRESH, e -> {
            TreeItem item = this.findItem((AbstractEntity)e.getValue(), (Collection)this.getTableView().getRoot().getChildren());
            if (item != null) {
                Item i = (Item)e.getValue();
                i.setStock(((Item)item.getValue()).getStock());
                item.setValue((Object)i);
            }
        });
    }
}

