/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.document;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.DDetailDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.Output;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.beans.DocumentSum;
import rs.tetrabyte.pezar.browser.EBrowser;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.ReportingService;
import rs.tetrabyte.pezar.controller.RepoNavigationViewController;
import rs.tetrabyte.pezar.controller.browser.EBrowserTableSearchViewController;
import rs.tetrabyte.pezar.controller.browser.document.DEditorViewController;
import rs.tetrabyte.pezar.controller.browser.document.DTablePerspectiveController;
import rs.tetrabyte.pezar.controller.browser.document.DTotalsController;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.pezar.rest.RepoSearchBuilder;

@FXMLView(value="/fxml/browser/document/DBrowserView.fxml", wrappers={LockablePaneWrapper.class})
public class DBrowserController
extends FXMLController
implements EBrowser {
    @FXML
    private BorderPane perspectiveContainer;
    @FXML
    private BorderPane navigationBox;
    @FXML
    private BorderPane summaryContainer;
    @FXML
    private BorderPane attributeSearchPane;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private ReportingService reportingService;
    @Input
    private RepositoryFX<Document> documentRepo;
    @Input
    private EBrowserDescriptor browserDescriptor;
    @Input
    private RepositorySearch initialSearch;
    @rs.tetrabyte.fxml.annotation.Output
    private DDetailDescriptor detailDescriptor;
    @rs.tetrabyte.fxml.annotation.Output(value="selectedDocument")
    private ObjectProperty<Document> selectedDocument = new SimpleObjectProperty();
    @rs.tetrabyte.fxml.annotation.Output
    private EventHandler<Event> onAction = e -> this.onView(null);
    @rs.tetrabyte.fxml.annotation.Output(value="globalSummary")
    private List<DocumentSum> summary = new ArrayList();
    @rs.tetrabyte.fxml.annotation.Output
    StringProperty entityId = new SimpleStringProperty();
    private Node editorView;

    public void initialize(URL location, ResourceBundle resources) {
        this.documentRepo.staticParam("status", (Object)"1");
    }

    @FXML
    protected void onEdit(ActionEvent event) {
        if (this.selectedDocument.get() == null) {
            return;
        }
        this.documentRepo.readOne(((Document)this.selectedDocument.get()).getId());
    }

    @FXML
    public void onDelete(ActionEvent event) {
        if (this.selectedDocument.get() == null) {
            return;
        }
        this.uiCommands.showAlert().confirm().withMessage("%alert.delete.msg", new Object[0]).withTitle("%alert.delete.title", new Object[0]).onConfirmed(e -> {
            if (this.selectedDocument.get() != null) {
                this.documentRepo.delete((ResourceEntity)((Document)this.selectedDocument.get()));
            }
        }).execute();
    }

    @FXML
    public void onRefresh(ActionEvent event) {
        this.documentRepo.search(this.documentRepo.getLastSearch());
    }

    @FXML
    public void onView(ActionEvent event) {
        if (this.selectedDocument.get() != null) {
            this.reportingService.showReport((Document)this.selectedDocument.get());
        }
    }

    @FXML
    public void onTablePerspective(ActionEvent event) {
    }

    @FXML
    public void onGridPerspective(ActionEvent event) {
    }

    @PostConstruct
    private void loadViews() {
        this.restTaskFactory.createTask(client -> {
            String path = client.pathBuilder().base().slash("ui-descriptors").slash("browsers").slash(this.browserDescriptor.getBrowserId()).slash("details").get();
            return (DDetailDescriptor)client.getObject(path, DDetailDescriptor.class, null);
        }).whenDone(descriptor -> {
            this.detailDescriptor = descriptor;
            Runnable onFinished = () -> this.uiCommands.removeView(this.editorView).execute();
            this.loadView(DEditorViewController.class).output(new Object[]{this}).output(Output.value((String)"onFinished", (Object)onFinished)).get(view -> {
                Node node = this.editorView = view;
            });
            this.loadView(DTablePerspectiveController.class).get(view -> {
                this.perspectiveContainer.setCenter(view);
                if (this.initialSearch == null) {
                    this.initialSearch = RepoSearchBuilder.documentsFinished((String)this.browserDescriptor.getBrowserId().split("/")[1]);
                }
                this.documentRepo.search(this.initialSearch);
            });
            this.loadView(RepoNavigationViewController.class).get(arg_0 -> ((BorderPane)this.navigationBox).setCenter(arg_0));
            this.loadView(DTotalsController.class).get(arg_0 -> ((BorderPane)this.summaryContainer).setCenter(arg_0));
            this.loadView(EBrowserTableSearchViewController.class).get(arg_0 -> ((BorderPane)this.attributeSearchPane).setCenter(arg_0));
        }).execute();
    }

    @PostConstruct
    private void configureBinding() {
        this.documentRepo.runningProperty().addListener((o, ov, nv) -> ((LockablePane)this.getRootNode(LockablePane.class)).setLocked(nv.booleanValue()));
    }

    @PostConstruct
    private void configureReadTemplate() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_TEMPLATE_OK, e -> this.uiCommands.displayContent(this.editorView).execute());
    }

    @PostConstruct
    private void configureReadOne() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_ONE_OK, e -> this.uiCommands.displayContent(this.editorView).execute());
    }

    @PostConstruct
    private void configureDelete() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.DELETE_OK, e -> this.uiCommands.removeView(this.editorView).execute());
    }

    public void setOnCommit(EventHandler<Event> onCommit) {
        throw new IllegalArgumentException("Method not supported");
    }

    public AbstractEntity getCommittedResource() {
        throw new IllegalArgumentException("Method not supported");
    }

    public void onOpened() {
        throw new IllegalArgumentException("Method not supported");
    }
}

