/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.document;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.DDetailDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.DLineDescriptor;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.fxml.annotation.Output;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.beans.DocumentLine;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.AcceleratorService;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.context.FocusService;
import rs.tetrabyte.pezar.context.ReportingService;
import rs.tetrabyte.pezar.controller.browser.document.DFinishViewController;
import rs.tetrabyte.pezar.controller.browser.document.DHeaderViewController;
import rs.tetrabyte.pezar.controller.browser.document.DLinesTableViewController;
import rs.tetrabyte.pezar.controller.browser.document.DSummaryController;
import rs.tetrabyte.pezar.custom.FormView;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;

@FXMLView(value="/fxml/browser/document/DEditorView.fxml", wrappers={LockablePaneWrapper.class})
public class DEditorViewController
extends FXMLController {
    @FXML
    private BorderPane formPane;
    @FXML
    private TitledPane detailsPane;
    @FXML
    private BorderPane summaryPane;
    @FXML
    private ToolBar toolbarLeft;
    @Autowired
    private UICommands commands;
    @Autowired
    private ReportingService reportingService;
    @Autowired
    private RestClient restClient;
    @Autowired
    private AcceleratorService accelerators;
    @Autowired
    private FocusService focusService;
    @Autowired
    private ControlsFactoryService cfs;
    @Input
    private RepositoryFX<Document> documentRepo;
    @Input
    private ObjectProperty<Document> selectedDocument;
    @Input
    private DDetailDescriptor detailDescriptor;
    @Output
    ObjectProperty<FormView.FormMode> formMode = new SimpleObjectProperty();
    @Output(value="lineRepository")
    private ObjectProperty<RepositoryFX<DocumentLine>> lineRepo = new SimpleObjectProperty();
    private TabPane tabPane;

    @FXML
    public void onDelete(ActionEvent event) {
        this.commands.showAlert().confirm().withMessage("%alert.delete.msg", new Object[0]).withTitle("%alert.delete.title", new Object[0]).onConfirmed(e -> {
            if (this.selectedDocument.get() != null) {
                this.documentRepo.delete((ResourceEntity)((Document)this.selectedDocument.get()));
            }
        }).execute();
    }

    @FXML
    public void onFinishDocument() {
        Runnable onCanceled = () -> ((LockablePane)this.getRootNode(LockablePane.class)).popNode();
        this.loadView(DFinishViewController.class).output("onCanceled", (Object)onCanceled).get(finishView -> ((LockablePane)this.getRootNode(LockablePane.class)).addNodeOnTop(finishView));
    }

    @FXML
    public void onPreview(ActionEvent event) {
        if (this.selectedDocument.get() != null) {
            this.reportingService.showReport((Document)this.selectedDocument.get());
        }
    }

    @PostConstruct
    private void initViews() {
        this.configureDocumentInsertOrRead();
        this.loadView(DHeaderViewController.class).get(arg_0 -> ((BorderPane)this.formPane).setCenter(arg_0));
        this.loadView(DSummaryController.class).get(arg_0 -> ((BorderPane)this.summaryPane).setCenter(arg_0));
        if (this.detailDescriptor.getLines().size() > 1) {
            this.tabPane = new TabPane();
            this.tabPane.setFocusTraversable(false);
            this.tabPane.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
                if (nv != null && nv.getContent() != null) {
                    this.accelerators.refresh();
                    this.focusService.setFocus(nv.getContent());
                }
            });
            this.detailsPane.setContent((Node)this.tabPane);
            DLineDescriptor lineDescriptor = (DLineDescriptor)this.detailDescriptor.getLines().get(0);
            Tab tab = this.addTab(lineDescriptor);
            FXMLController.FXMLJob job = this.loadView(DLinesTableViewController.class).output(new Object[]{lineDescriptor}).prepare(arg_0 -> ((Tab)tab).setContent(arg_0));
            int i = 1;
            while (i < this.detailDescriptor.getLines().size()) {
                lineDescriptor = (DLineDescriptor)this.detailDescriptor.getLines().get(i);
                tab = this.addTab(lineDescriptor);
                job = job.loadView(DLinesTableViewController.class).output(new Object[]{lineDescriptor}).prepare(arg_0 -> ((Tab)tab).setContent(arg_0));
                ++i;
            }
            job.load();
        } else {
            this.loadView(DLinesTableViewController.class).output(new Object[]{this.detailDescriptor.getLines().get(0)}).get(arg_0 -> ((TitledPane)this.detailsPane).setContent(arg_0));
        }
    }

    private void configureDocumentInsertOrRead() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.INSERT_OK, e -> this.createLineRepository(e));
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_ONE_OK, e -> this.createLineRepository(e));
    }

    private void createLineRepository(RepositoryFXEvent<?> e) {
        this.lineRepo.set((Object)new RepositoryFX("documentLines", ((Document)e.getValue()).getLink("lines").getHref(), DocumentLine.class, null, this.restClient));
        if (this.tabPane != null) {
            this.tabPane.getSelectionModel().select(0);
        }
        ((RepositoryFX)this.lineRepo.get()).readAll();
    }

    private Tab addTab(DLineDescriptor lineDescriptor) {
        Tab tab = this.cfs.createAcceleratedTab(lineDescriptor);
        tab.setClosable(false);
        tab.getProperties().put((Object)"lineDescriptor", (Object)lineDescriptor);
        this.tabPane.getTabs().add((Object)tab);
        return tab;
    }
}

