/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.document;

import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.DDetailDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.context.FocusService;
import rs.tetrabyte.pezar.controller.browser.EBrowserController;
import rs.tetrabyte.pezar.controller.browser.document.DTaxViewController;
import rs.tetrabyte.pezar.custom.FormView;
import rs.tetrabyte.pezar.custom.FormWrapper;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;

@FXMLView(value="/fxml/browser/document/DHeaderView.fxml", wrappers={FormWrapper.class, LockablePaneWrapper.class})
public class DHeaderViewController
extends FXMLController {
    @FXML
    private BorderPane rootPane;
    @FXML
    private ScrollPane content;
    @FXML
    private CheckBox chkSubType;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnUpdateHeader;
    @Autowired
    private FocusService focusManager;
    @Autowired
    private ControlsFactoryService cfs;
    @Input
    private RepositoryFX<Document> documentRepo;
    @Input
    private EBrowserDescriptor browserDescriptor;
    @Input
    private EBrowserController browserController;
    @Input
    private DDetailDescriptor detailDescriptor;
    @Input
    private StringProperty discriminator;
    @Input
    private ObjectProperty<Document> selectedDocument;
    @Input
    private ObjectProperty<FormView.FormMode> formMode;
    private FormView<Document> formView;
    private int modelHashCode;

    @FXML
    public void onSave(ActionEvent event) {
        if (this.formView != null && this.cfs.validateOnDemand((Node)this.formView)) {
            Document model = (Document)this.formView.getModel();
            if (this.formView.getFormMode() == FormView.FormMode.INSERT) {
                if (this.chkSubType.isSelected() && this.selectedDocument.get() != null) {
                    model.setParent(((Document)this.selectedDocument.get()).getId().getHref());
                }
                this.documentRepo.insert((ResourceEntity)model);
            } else if (this.formView.getFormMode() == FormView.FormMode.UPDATE) {
                if (this.modelHashCode != ((Document)this.formView.getModel()).hashCode()) {
                    model.setSummary(null);
                    this.documentRepo.update((ResourceEntity)model);
                } else {
                    this.formView.setFormMode(FormView.FormMode.NONE);
                }
            }
        }
    }

    @FXML
    public void onUpdateHeader(ActionEvent event) {
        this.formView.setFormMode(FormView.FormMode.UPDATE);
        this.formView.requestFocus();
    }

    @PostConstruct
    public void configureBinding() {
        this.btnUpdateHeader.disableProperty().bind((ObservableValue)this.btnSave.disabledProperty().not());
        ((LockablePane)this.getRootNode(LockablePane.class)).lockedProperty().bind((ObservableValue)this.documentRepo.runningProperty());
    }

    @PostConstruct
    private void configureReadTemplate() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_TEMPLATE_OK, e -> {
            this.rootPane.setBottom(null);
            this.createForm(FormView.FormMode.INSERT, (Document)e.getValue());
        });
    }

    @PostConstruct
    private void configureReadOne() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_ONE_OK, e -> {
            this.createForm(FormView.FormMode.UPDATE, (Document)e.getValue());
            this.formView.setFormMode(FormView.FormMode.NONE);
            if (this.formView != null) {
                Platform.runLater(() -> {
                    boolean bl = this.cfs.validateOnDemand((Node)this.formView);
                });
            }
            if (this.detailDescriptor.getTaxDescriptor() != null) {
                this.loadView(DTaxViewController.class).get(view -> this.rootPane.setBottom(view));
            }
        });
    }

    @PostConstruct
    private void configureSave() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.SAVE_OK, e -> {
            this.formView.setModel((Object)((Document)e.getValue()));
            this.formView.setFormMode(FormView.FormMode.NONE);
            this.modelHashCode = ((Document)e.getValue()).hashCode();
            if (this.detailDescriptor.getTaxDescriptor() != null) {
                this.loadView(DTaxViewController.class).get(view -> this.rootPane.setBottom(view));
            }
        });
    }

    private void createForm(FormView.FormMode formMode, Document document) {
        this.chkSubType.setVisible(((EFormDescriptor)this.browserDescriptor.getForms().get(0)).isRecursive());
        EFormDescriptor formDescriptor = (EFormDescriptor)this.browserDescriptor.getForms().get(0);
        this.formView = this.cfs.createFormView(formDescriptor, Orientation.VERTICAL);
        this.formView.setFieldGroupFilter(g -> "default".equals(g.getGroupId()));
        this.formView.setFormMode(formMode);
        this.formView.setModel((Object)document);
        this.modelHashCode = document.hashCode();
        this.content.setContent((Node)this.formView);
        this.focusManager.setFocus((Node)this.formView);
        this.formMode.unbind();
        this.formMode.bind((ObservableValue)this.formView.formModeProperty());
        this.btnSave.disableProperty().unbind();
        this.btnSave.disableProperty().bind((ObservableValue)this.formView.formModeProperty().isEqualTo((Object)FormView.FormMode.NONE));
    }
}

