/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.document;

import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Resources;
import rs.tetrabyte.datamodel.uidescriptors.entity.DLineDescriptor;
import rs.tetrabyte.datarest.client.Params;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.beans.DocumentLine;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.controller.RepoNavigationViewController;
import rs.tetrabyte.pezar.controller.browser.document.DLineFormViewController;
import rs.tetrabyte.pezar.custom.FormView;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;

@FXMLView(value="/fxml/browser/document/DLinesTableView.fxml", wrappers={LockablePaneWrapper.class})
public class DLinesTableViewController
extends FXMLController
implements Initializable {
    @FXML
    private TreeTableView<DocumentLine> tableView;
    @FXML
    private BorderPane navigationBox;
    @Autowired
    RestTaskFactory restTaskFactory;
    @Autowired
    RestClient restClient;
    @Autowired
    UICommands uiCommands;
    @Autowired
    ControlsFactoryService cfs;
    @Input
    private DLineDescriptor lineDescriptor;
    @Input
    private ObjectProperty<FormView.FormMode> formMode;
    @Input(value="lineRepository")
    private ObjectProperty<RepositoryFX<DocumentLine>> lineRepo;
    @Input
    RepositoryFX<Document> documentRepo;
    private Parent formContainer;
    private ObjectProperty<DocumentLine> selectedItem = new SimpleObjectProperty();

    public void initialize(URL location, ResourceBundle resources) {
        String tableId = String.valueOf(this.documentRepo.getId().replace("/", "-")) + "-items";
        this.tableView.setId(tableId);
    }

    @FXML
    protected void onNew(ActionEvent event) {
        ((RepositoryFX)this.lineRepo.get()).readTemplate(new Params().param("d", (Object)this.lineDescriptor.getDiscriminator()));
    }

    @FXML
    protected void onEdit(ActionEvent event) {
        if (this.selectedItem.get() != null) {
            ((RepositoryFX)this.lineRepo.get()).readOne(((DocumentLine)this.selectedItem.getValue()).getLink("self"));
        }
    }

    @FXML
    public void onDelete(ActionEvent event) {
        if (this.selectedItem.get() == null) {
            return;
        }
        this.uiCommands.showAlert().confirm().withMessage("%alert.delete.msg", new Object[0]).withTitle("%alert.delete.title", new Object[0]).onConfirmed(e -> {
            if (this.selectedItem.get() != null) {
                ((RepositoryFX)this.lineRepo.get()).delete((ResourceEntity)((DocumentLine)this.selectedItem.get()));
            }
        }).execute();
    }

    @FXML
    public void onRefresh(ActionEvent event) {
        ((RepositoryFX)this.lineRepo.get()).search(((RepositoryFX)this.lineRepo.get()).getLastSearch());
    }

    @PostConstruct
    public void initView() {
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ENTER) {
                this.onEdit(null);
            }
        });
        this.tableView.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getClickCount() == 2) {
                this.onEdit(null);
            }
        });
        this.tableView.setRoot(new TreeItem());
        this.tableView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.selectedItem.set(nv != null ? (DocumentLine)nv.getValue() : null));
        this.formMode.addListener((o, ov, nv) -> {
            this.getRootNode(Node.class).setDisable(nv != FormView.FormMode.NONE);
            if (nv == FormView.FormMode.NONE) {
                this.tableView.requestFocus();
            }
        });
        this.loadView(RepoNavigationViewController.class).prepare(arg_0 -> ((BorderPane)this.navigationBox).setCenter(arg_0)).loadView(DLineFormViewController.class).ofType(Parent.class).output(new Object[]{this}).prepare(view -> {
            Parent parent = this.formContainer = view;
        }).load();
    }

    @PostConstruct
    private void configureDocumentReadTemplate() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_TEMPLATE_OK, e -> this.tableView.getRoot().getChildren().clear());
    }

    @PostConstruct
    private void configureDocumentReadOne() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_ONE_OK, e -> this.initRepo(e));
    }

    @PostConstruct
    private void configureDocumentInsert() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.INSERT_OK, e -> this.initRepo(e));
    }

    private void initRepo(RepositoryFXEvent<?> e) {
        this.tableView.getRoot().getChildren().clear();
        ((RepositoryFX)this.lineRepo.get()).addEventFilter(RepositoryFXEvent.READ_MANY_OK, e1 -> {
            Resources resources = (Resources)e1.getValue();
            this.tableView.getRoot().getChildren().clear();
            if (resources != null && resources.getContent().size() > 0) {
                this.tableView.getRoot().getChildren().addAll((Collection)resources.getContent().stream().filter(line -> line.getDiscriminator().equals(this.lineDescriptor.getDiscriminator())).map(TreeItem::new).collect(Collectors.toList()));
                this.tableView.getSelectionModel().select(0);
                this.tableView.requestFocus();
            }
        });
        ((RepositoryFX)this.lineRepo.get()).addEventFilter(RepositoryFXEvent.INSERT_OK, e1 -> {
            DocumentLine line = (DocumentLine)e1.getValue();
            if (!line.getDiscriminator().equals(this.lineDescriptor.getDiscriminator())) {
                return;
            }
            TreeItem newItem = new TreeItem((Object)line);
            this.tableView.getRoot().getChildren().add((Object)newItem);
            this.tableView.getSelectionModel().select((Object)newItem);
            this.uiCommands.showNotification().success().withText("%msg.save-success", new Object[0]).withPosition(Pos.BOTTOM_RIGHT).withDuration(1).execute();
            this.hideForm();
            this.onNew(null);
        });
        ((RepositoryFX)this.lineRepo.get()).addEventFilter(RepositoryFXEvent.UPDATE_OK, e1 -> {
            DocumentLine line = (DocumentLine)e1.getValue();
            if (!line.getDiscriminator().equals(this.lineDescriptor.getDiscriminator())) {
                return;
            }
            ((TreeItem)this.tableView.getSelectionModel().getSelectedItem()).setValue((Object)line);
            this.hideForm();
            this.uiCommands.showNotification().success().withText("%msg.save-success", new Object[0]).withPosition(Pos.BOTTOM_RIGHT).withDuration(1).execute();
        });
        ((RepositoryFX)this.lineRepo.get()).addEventFilter(RepositoryFXEvent.DELETE_OK, e1 -> {
            DocumentLine line = (DocumentLine)e1.getValue();
            if (!line.getDiscriminator().equals(this.lineDescriptor.getDiscriminator())) {
                return;
            }
            this.tableView.getRoot().getChildren().remove(this.tableView.getSelectionModel().getSelectedItem());
        });
        ((RepositoryFX)this.lineRepo.get()).addEventFilter(RepositoryFXEvent.READ_TEMPLATE_OK, e1 -> {
            DocumentLine line = (DocumentLine)e1.getValue();
            if (!line.getDiscriminator().equals(this.lineDescriptor.getDiscriminator())) {
                return;
            }
            this.showForm();
        });
        ((RepositoryFX)this.lineRepo.get()).addEventFilter(RepositoryFXEvent.READ_ONE_OK, e1 -> {
            DocumentLine line = (DocumentLine)e1.getValue();
            if (!line.getDiscriminator().equals(this.lineDescriptor.getDiscriminator())) {
                return;
            }
            this.showForm();
        });
        ((LockablePane)this.getRootNode(LockablePane.class)).lockedProperty().unbind();
        ((LockablePane)this.getRootNode(LockablePane.class)).lockedProperty().bind((ObservableValue)((RepositoryFX)this.lineRepo.get()).runningProperty());
    }

    @PostConstruct
    protected void createColumns() {
        this.tableView.getColumns().addAll((Collection)this.cfs.createTreeTableColumns(this.lineDescriptor.getTable()));
    }

    private void showForm() {
        ((LockablePane)this.getRootNode(LockablePane.class)).addNodeOnTop((Node)this.formContainer, false);
    }

    public void hideForm() {
        if (this.formContainer != null) {
            ((LockablePane)this.getRootNode(LockablePane.class)).popNode();
        }
    }
}

