/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.user;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.task.RestTask;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Permission;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.beans.Role;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.controller.browser.user.RoleFormViewController;
import rs.tetrabyte.pezar.controller.browser.user.UsersRolesViewController;
import rs.tetrabyte.pezar.custom.validator.Validators;

@FXMLView(value="/fxml/user/RoleFormView.fxml")
public class RoleFormViewController
extends FXMLController {
    @FXML
    private VBox content;
    @FXML
    private TextField txtName;
    @FXML
    private TableView<Permission> tableEntities;
    @FXML
    private TableColumn<Permission, String> colEntitiesName;
    @FXML
    private TableColumn<Permission, Permission.Authority> colEntitiesValue;
    @FXML
    private ComboBox<Role> cbRoleBase;
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private ControlsFactoryService cs;
    @Input
    private RepositoryFX<Role> repository;
    @Input
    private UsersRolesViewController browserController;
    private Role resource;

    @FXML
    public void onSave(ActionEvent event) {
        if (!this.cs.validateOnDemand((Node)this.content)) {
            return;
        }
        if (this.resource.hasLink("self")) {
            this.resource.setPermissions((List)this.tableEntities.getItems());
            this.repository.update((ResourceEntity)this.resource);
        } else {
            this.resource.setPermissions((List)this.tableEntities.getItems());
            this.resource.setResidentId(((Resident)this.browserController.getParams().get("resident")).getResidentId());
            this.repository.insert((ResourceEntity)this.resource);
        }
    }

    @FXML
    public void onCancel(ActionEvent event) {
        this.browserController.hideForm();
        this.tableEntities.getItems().clear();
    }

    private void setRepository() {
        this.repository.setOnReadTemplate(e -> this.setRole((Role)e.getValue()));
        this.repository.setOnReadOne(e -> this.setRole((Role)e.getValue()));
        this.repository.setOnSave(e -> {
            if (e.getEventType().getSuperType() == RepositoryFXEvent.SAVE_OK) {
                this.tableEntities.getItems().clear();
            }
        });
    }

    private void setRole(Role resource) {
        this.txtName.requestFocus();
        this.cbRoleBase.getItems().setAll((Collection)((ObservableList)this.repository.getResponseCollection().responseListProperty().get()).filtered(r -> resource.hasLink("self") ? !resource.getLink("self").equals((Object)r.getLink("self")) : true));
        if (this.resource != null) {
            this.unBind(this.resource);
        }
        this.resource = resource;
        this.bind(resource);
        RestTask task = (RestTask)this.restTaskFactory.createTask(client -> {
            String path = client.pathBuilder().base().slash("account/available-permissions/entity").get();
            return client.getList(path, Permission.class);
        }).whenDone(permissions -> {
            this.tableEntities.getItems().setAll((Collection)permissions);
            resource.getPermissions().forEach(perm -> this.tableEntities.getItems().stream().filter(p -> p.getId().equals(perm.getId())).findFirst().ifPresent(p -> p.setAuthority(perm.getAuthority())));
        });
        if (resource.hasLink("parent")) {
            task.join(this.restTaskFactory.createTask(client -> (Role)client.getSingle(resource.getLink("parent"), Role.class)).whenDone(res -> this.cbRoleBase.setValue(res))).lockUI(true).execute();
        } else {
            task.execute();
        }
    }

    private void bind(Role role) {
        this.txtName.textProperty().bindBidirectional((Property)role.nameProperty());
        Bindings.bindBidirectional((Property)role.parentProperty(), (Property)this.cbRoleBase.valueProperty(), (StringConverter)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void unBind(Role role) {
        this.txtName.textProperty().unbindBidirectional((Property)role.nameProperty());
        Bindings.unbindBidirectional((Object)role.parentProperty(), (Object)this.cbRoleBase.valueProperty());
        this.cbRoleBase.setValue(null);
    }

    public void initialize(URL location, ResourceBundle resources) {
        Validators.create((Control)this.txtName).required();
        this.cbRoleBase.setConverter((StringConverter)new /* Unavailable Anonymous Inner Class!! */);
        Pane header = (Pane)this.tableEntities.lookup("TableHeaderRow");
        if (header != null) {
            header.setMaxHeight(0.0);
            header.setMinHeight(0.0);
            header.setPrefHeight(0.0);
            header.setVisible(false);
        }
        this.colEntitiesName.setCellValueFactory(data -> ((Permission)data.getValue()).descriptionProperty());
        3 converter = new /* Unavailable Anonymous Inner Class!! */;
        Callback factory = ComboBoxTableCell.forTableColumn((StringConverter)converter, (Object[])Permission.Authority.values());
        this.colEntitiesValue.setCellFactory(factory);
        this.colEntitiesValue.setCellValueFactory(data -> ((Permission)data.getValue()).authorityProperty());
        this.setRepository();
    }

    static /* synthetic */ RepositoryFX access$0(RoleFormViewController roleFormViewController) {
        return roleFormViewController.repository;
    }
}

