/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.user;

import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.beans.Role;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.controller.browser.user.UsersRolesViewController;

@FXMLView(value="/fxml/user/RolesTablePerspective.fxml")
public class RolesTablePerspectiveController
extends FXMLController {
    @FXML
    private ComboBox<Resident> cbResidents;
    @FXML
    private ListView<Role> listRoles;
    @Autowired
    private TenantContext tenantContext;
    @Input
    private RepositoryFX<Role> repository;
    @Input
    private UsersRolesViewController browserController;
    @Input
    private ObjectProperty<Role> selectedResource;

    private void setRepository() {
        this.selectedResource.bind((ObservableValue)this.listRoles.getSelectionModel().selectedItemProperty());
        this.listRoles.itemsProperty().bind((ObservableValue)this.repository.getResponseCollection().responseListProperty());
        this.listRoles.setCellFactory((Callback)new /* Unavailable Anonymous Inner Class!! */);
        this.repository.setOnReadCollection(e -> {
            this.listRoles.requestFocus();
            if (!this.listRoles.getItems().isEmpty()) {
                this.listRoles.getSelectionModel().select(0);
            }
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cbResidents.getItems().setAll((Collection)this.tenantContext.getResidents());
        this.cbResidents.getSelectionModel().select((Object)((Resident)this.tenantContext.getActiveResident().get()));
        this.cbResidents.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            this.repository.search(RepositorySearch.builder().withRel("residentRoleLevel").withParam("residentId", nv.getResidentId()).withParam("roleLevel", "ROLE_USER").build());
            this.browserController.getParams().put("resident", nv);
        });
        this.setRepository();
    }
}

