/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.user;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import jidefx.scene.control.field.FormattedTextField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.client.parametrizedType.ResponseType;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.beans.Role;
import rs.tetrabyte.pezar.beans.User;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.controller.browser.user.UsersRolesViewController;
import rs.tetrabyte.pezar.custom.FormWrapper;
import rs.tetrabyte.pezar.custom.validator.Validators;
import rs.tetrabyte.pezar.custom.validator.Verifiers;

@FXMLView(value="/fxml/user/UserFormView.fxml", wrappers={FormWrapper.class})
public class UserFormViewController
extends FXMLController {
    @FXML
    private FormattedTextField<String> txtUserName;
    @FXML
    private PasswordField txtPassword;
    @FXML
    private TextField txtFirstName;
    @FXML
    private TextField txtLastName;
    @FXML
    private ComboBox<Resident> cbResidents;
    @FXML
    private ComboBox<Role> cbRoles;
    @FXML
    private ComboBox<Resident> cbDefaultResident;
    @FXML
    private Button btnAddRole;
    @FXML
    private TextField txtEmail;
    @FXML
    private ListView<Role> listRoles;
    @FXML
    private GridPane content;
    @FXML
    private CheckBox cbSuperuser;
    @FXML
    private CheckBox cbEnabled;
    @Autowired
    private TenantContext tenantContext;
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private ControlsFactoryService cs;
    @Input
    private UsersRolesViewController browserController;
    @Input
    private RepositoryFX<User> repository;
    private User resource;

    @FXML
    public void addRole(ActionEvent event) {
        if (this.cbRoles.getSelectionModel().getSelectedIndex() == -1) {
            return;
        }
        if (!this.listRoles.getItems().stream().filter(role -> role.getResidentId().equals(((Role)this.cbRoles.getSelectionModel().getSelectedItem()).getResidentId())).findFirst().isPresent()) {
            Role role2 = (Role)this.cbRoles.getSelectionModel().getSelectedItem();
            this.listRoles.getItems().add((Object)role2);
            this.fillCbDefaultResident();
            if (this.listRoles.getItems().size() == 1) {
                this.cbDefaultResident.getSelectionModel().select((Object)this.cbDefaultResident.getItems().stream().filter(r -> role2.getResidentId().equals(r.getResidentId())).findFirst().get());
            }
        }
    }

    @FXML
    public void onCancel(ActionEvent event) {
        this.browserController.hideForm();
    }

    @FXML
    public void onSave(ActionEvent event) {
        if (!this.cs.validateOnDemand((Node)this.content)) {
            return;
        }
        if (this.listRoles.getItems().size() == 0) {
            this.uiCommands.showNotification().error().withDuration(Duration.seconds((double)2.0)).withPosition(Pos.CENTER).withText("%msg.err.no-roles-assigned", new Object[0]).execute();
            return;
        }
        this.resource.setRoles(this.listRoles.getItems().stream().map(r -> r.getLink("self").getHref()).collect(Collectors.toList()));
        if (this.isUpdate()) {
            this.repository.update((ResourceEntity)this.resource);
        } else {
            this.repository.insert((ResourceEntity)this.resource);
        }
    }

    private void setRepository() {
        this.repository.setOnReadTemplate(e -> {
            Validators.create((Control)this.txtPassword).required();
            this.setUser((User)e.getValue());
        });
        this.repository.setOnReadOne(e -> {
            Validators.uninstall((Control)this.txtPassword);
            this.setUser((User)e.getValue());
        });
    }

    private void setUser(User resource) {
        if (this.resource != null) {
            this.unBind(this.resource);
        }
        Resident resident = this.tenantContext.getResidents().stream().filter(r -> r.getResidentId().equals(resource.getDefaultResident())).findFirst().orElse(null);
        this.bind(resource);
        this.fillCbDefaultResident();
        this.cbDefaultResident.getSelectionModel().select((Object)resident);
        this.resource = resource;
        this.txtUserName.setDisable(this.isUpdate());
        this.restTaskFactory.createTask(client -> {
            Collection resources = new ArrayList();
            if (resource.hasLink("roles")) {
                Resources roles = (Resources)client.getCollection(resource.getLink("roles"), (ParameterizedTypeReference)ResponseType.resources(Role.class));
                resources = roles.getContent();
            }
            return resources;
        }).whenDone(roles -> this.listRoles.getItems().setAll(roles)).execute();
        if (!this.isUpdate()) {
            this.txtUserName.requestFocus();
        }
    }

    private boolean isUpdate() {
        return this.resource != null && this.resource.hasLink("self");
    }

    private void bind(User u) {
        this.txtEmail.textProperty().bindBidirectional((Property)u.emailProperty());
        this.txtFirstName.textProperty().bindBidirectional((Property)u.firstNameProperty());
        this.txtLastName.textProperty().bindBidirectional((Property)u.lastNameProperty());
        this.txtPassword.textProperty().bindBidirectional((Property)u.passwordProperty());
        this.txtUserName.textProperty().bindBidirectional((Property)u.usernameProperty());
        this.cbEnabled.selectedProperty().bindBidirectional((Property)u.enabledProperty());
        Bindings.bindBidirectional((Property)u.defaultResidentProperty(), (Property)this.cbDefaultResident.valueProperty(), (StringConverter)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void unBind(User u) {
        this.txtEmail.textProperty().unbindBidirectional((Property)u.emailProperty());
        this.txtFirstName.textProperty().unbindBidirectional((Property)u.firstNameProperty());
        this.txtLastName.textProperty().unbindBidirectional((Property)u.lastNameProperty());
        this.txtPassword.textProperty().unbindBidirectional((Property)u.passwordProperty());
        this.txtUserName.textProperty().unbindBidirectional((Property)u.usernameProperty());
        this.cbEnabled.selectedProperty().unbindBidirectional((Property)u.enabledProperty());
        Bindings.unbindBidirectional((Object)u.defaultResidentProperty(), (Object)this.cbDefaultResident.valueProperty());
    }

    private void fillCbDefaultResident() {
        List residents = this.listRoles.getItems().stream().map(role -> this.tenantContext.getResidents().stream().filter(resident -> resident.getResidentId().equals(role.getResidentId())).findFirst().orElse(null)).collect(Collectors.toList());
        Resident selectedResident = (Resident)this.cbDefaultResident.getSelectionModel().getSelectedItem();
        this.cbDefaultResident.getItems().setAll(residents);
        this.cbDefaultResident.getSelectionModel().select((Object)selectedResident);
    }

    public void initialize(URL location, ResourceBundle resources) {
        Verifiers.userName().install(this.txtUserName);
        Validators.create((Control)this.txtUserName).userName().required();
        Validators.create((Control)this.txtFirstName).word();
        Validators.create((Control)this.txtLastName).word();
        Validators.create((Control)this.txtEmail).email();
        Validators.create((Control)this.cbDefaultResident).required();
        this.cbResidents.disableProperty().bind((ObservableValue)this.cbSuperuser.selectedProperty());
        this.cbRoles.disableProperty().bind((ObservableValue)this.cbSuperuser.selectedProperty());
        this.listRoles.disableProperty().bind((ObservableValue)this.cbSuperuser.selectedProperty());
        this.btnAddRole.setGraphic((Node)new FontAwesomeIconView(FontAwesomeIcon.PLUS_CIRCLE, "20"));
        this.listRoles.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                this.listRoles.getItems().remove(this.listRoles.getSelectionModel().getSelectedItem());
            }
        });
        this.listRoles.setCellFactory((Callback)new /* Unavailable Anonymous Inner Class!! */);
        this.cbRoles.setConverter((StringConverter)new /* Unavailable Anonymous Inner Class!! */);
        this.setRepository();
    }

    @PostConstruct
    public void postInit() {
        this.cbResidents.getItems().addAll((Collection)this.tenantContext.getResidents());
        this.cbResidents.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.restTaskFactory.createTask(client -> {
            List roles = client.getList(client.pathBuilder().base().slash("account/roles").get(), Role.class);
            roles.stream().forEach(role -> {
                boolean bl = role.getLinks().add(new Link(client.pathBuilder().root().slash("roles").slash(String.valueOf(role.getRoleId())).get(), "self"));
            });
            return roles;
        }).whenDone(roles -> {
            this.cbRoles.getSelectionModel().clearSelection();
            this.cbRoles.getItems().setAll((Collection)roles.stream().filter(r -> r.getResidentId().equals(((Resident)this.cbResidents.getSelectionModel().getSelectedItem()).getResidentId())).collect(Collectors.toList()));
        }).execute());
        if (this.tenantContext.getResidents().size() == 1) {
            this.cbResidents.getSelectionModel().select(0);
        }
    }

    static /* synthetic */ TenantContext access$0(UserFormViewController userFormViewController) {
        return userFormViewController.tenantContext;
    }
}

