/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom;

import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import rs.tetrabyte.pezar.factory.GlyphFactory;

public class AccelerablePane
extends GridPane {
    private GridPane labelPane;
    private Node glyph;
    private Text text;
    private Text txtShortcut;
    private Text text1;

    public AccelerablePane(Orientation orientation, Pos alignment) {
        this.setHgap(2.0);
        this.setVgap(1.0);
        this.setAlignment(alignment);
        this.labelPane = new GridPane();
        this.labelPane.setAlignment(alignment);
        this.labelPane.setVgap(0.0);
        GridPane.setConstraints((Node)this.labelPane, (int)1, (int)0);
        this.getChildren().add((Object)this.labelPane);
        this.getStyleClass().add((Object)"accelerable");
        this.text = new Text();
        this.text.getStyleClass().add((Object)"text");
        GridPane.setConstraints((Node)this.text, (int)0, (int)0);
        GridPane.setHalignment((Node)this.text, (HPos)HPos.CENTER);
        this.labelPane.getChildren().add((Object)this.text);
        this.text1 = new Text();
        this.text1.getStyleClass().add((Object)"text");
        GridPane.setConstraints((Node)this.text1, (int)1, (int)0);
        GridPane.setHalignment((Node)this.text1, (HPos)HPos.CENTER);
        this.getChildren().add((Object)this.text1);
        this.txtShortcut = new Text();
        this.txtShortcut.getStyleClass().add((Object)"shortcut");
        GridPane.setHalignment((Node)this.txtShortcut, (HPos)HPos.CENTER);
        if (orientation == Orientation.VERTICAL) {
            GridPane.setConstraints((Node)this.txtShortcut, (int)0, (int)1);
        } else {
            GridPane.setConstraints((Node)this.txtShortcut, (int)1, (int)0);
        }
        this.labelPane.getChildren().add((Object)this.txtShortcut);
    }

    public void setAccelerator(String shortcut) {
        if (shortcut == null || "".equals(shortcut)) {
            return;
        }
        this.txtShortcut.setText(shortcut);
        if (this.text1.getText() != null && !"".equals(this.text1.getText())) {
            this.text.setText(this.text1.getText());
            this.text1.setText("");
        }
    }

    public void setGlyph(String code) {
        if (code == null || "".equals(code)) {
            return;
        }
        Node glyph = GlyphFactory.createGlyph((String)code);
        glyph.getStyleClass().add((Object)"glyph");
        if (glyph != null) {
            if (this.glyph != null) {
                this.getChildren().remove((Object)glyph);
            }
            GridPane.setMargin((Node)glyph, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
            GridPane.setConstraints((Node)glyph, (int)0, (int)0);
            this.getChildren().add((Object)glyph);
            this.glyph = glyph;
        }
    }

    public void setText(String text) {
        if (text == null || "".equals(text)) {
            return;
        }
        if (this.txtShortcut.getText() != null && !"".equals(this.txtShortcut.getText())) {
            this.text.setText(text);
        } else {
            this.text1.setText(text);
        }
    }
}

