/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom;

import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class FormFieldContainer
extends BorderPane {
    private String groupId;
    private String fieldId;
    private Control control;
    private int order;

    public FormFieldContainer(String fieldId, Label label, Node graphic, Control control, String groupId, int order, Orientation orientation) {
        this.fieldId = fieldId;
        this.groupId = groupId;
        this.order = order;
        HBox content = orientation == Orientation.HORIZONTAL ? new HBox() : new VBox();
        this.setCenter((Node)content);
        label.setFocusTraversable(false);
        if (graphic != null) {
            label.setGraphic(graphic);
        }
        if (orientation == Orientation.HORIZONTAL) {
            label.setAlignment(Pos.BOTTOM_RIGHT);
            label.setMinWidth(70.0);
            HBox.setMargin((Node)label, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
            HBox.setHgrow((Node)label, (Priority)Priority.SOMETIMES);
            content.setPadding(new Insets(5.0, 5.0, 0.0, 5.0));
        } else {
            label.setAlignment(Pos.BASELINE_LEFT);
            label.setMinWidth(70.0);
            VBox.setMargin((Node)label, (Insets)new Insets(1.0, 0.0, 5.0, 0.0));
        }
        if (control != null && orientation == Orientation.HORIZONTAL) {
            HBox.setMargin((Node)control, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
            HBox.setHgrow((Node)control, (Priority)Priority.ALWAYS);
        }
        content.getChildren().add((Object)label);
        if (control != null) {
            content.getChildren().add((Object)control);
        }
        this.control = control;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public Control getControl() {
        return this.control;
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return "FormFieldContainer [groupId=" + this.groupId + ", fieldId=" + this.fieldId + ", control=" + this.control + ", order=" + this.order + "]";
    }
}

