/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import rs.tetrabyte.pezar.custom.FormFieldContainer;

public class FormFieldGroup
extends TitledPane {
    private String groupId;
    private List<FormFieldContainer> fieldContainers = new ArrayList();
    private VBox groupContent;

    public FormFieldGroup(String id, String label, Node graphic, boolean expanded) {
        this.groupId = id;
        this.setGraphic(graphic);
        this.setText(label);
        this.setFocusTraversable(false);
        this.setExpanded(expanded);
        this.setId(id);
        this.groupContent = new VBox();
        this.setContent((Node)this.groupContent);
    }

    public void addFieldContainer(FormFieldContainer fieldContainer) {
        ObservableList nodes = this.groupContent.getChildren();
        int insertIndex = -1;
        int i = 0;
        while (i < nodes.size() && insertIndex == -1) {
            FormFieldContainer tmp = (FormFieldContainer)nodes.get(i);
            if (tmp.getOrder() >= fieldContainer.getOrder()) {
                insertIndex = i;
            }
            ++i;
        }
        if (insertIndex == -1) {
            nodes.add((Object)fieldContainer);
            this.fieldContainers.add(fieldContainer);
        } else {
            nodes.add(insertIndex, (Object)fieldContainer);
            this.fieldContainers.add(insertIndex, fieldContainer);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<FormFieldContainer> getFieldContainers() {
        return this.fieldContainers;
    }

    public List<Control> getFields() {
        return this.fieldContainers.stream().map(c -> c.getControl()).collect(Collectors.toList());
    }

    public void clear() {
        this.groupContent.getChildren().clear();
    }

    public String toString() {
        return "FormFieldGroup [groupId=" + this.groupId + ", fieldContainers=" + this.fieldContainers + "]";
    }
}

