/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom;

import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;
import jidefx.scene.control.decoration.DecorationDelegate;
import jidefx.scene.control.decoration.DecorationSupport;
import jidefx.scene.control.editor.Editor;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.hateoas.Resources;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datarest.client.Params;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.datarest.context.RepositoryFXContext;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.fxml.Output;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.custom.ReferenceFieldBrowserSupport;
import rs.tetrabyte.pezar.custom.ReferenceTextField;
import rs.tetrabyte.pezar.factory.field.util.EntityDescriptor;
import rs.tetrabyte.pezar.factory.field.util.ReferenceDescriptor;

public class ReferenceTextField
extends Control
implements ReferenceFieldBrowserSupport,
DecorationSupport,
Editor<String> {
    private TextField valueField;
    private Button descriptionField;
    private ObjectProperty<String> valueProperty = new SimpleObjectProperty();
    private StringConverter<String> converter;
    private boolean editCommitted;
    private UICommands uiCommands;
    private RepositoryFXContext repoCtx;
    private RestClient restClient;
    private DecorationDelegate _operator;
    private Output output;

    public ReferenceTextField(UICommands uiCommands, RepositoryFXContext repoCtx, RestClient client, EFormDescriptor.EFormFieldDescriptor desc) {
        this.getStyleClass().add((Object)"reference-text-field");
        this.uiCommands = uiCommands;
        this.repoCtx = repoCtx;
        this.restClient = client;
        this.setSkin((javafx.scene.control.Skin)new Skin(this, this));
        this.valueField = new TextField();
        this.valueField.setPrefWidth(50.0);
        this.valueField.setMinWidth(50.0);
        this.descriptionField = new Button();
        this.descriptionField.setFocusTraversable(false);
        this.descriptionField.setOnAction(e -> this.openBrowser(desc));
        this.descriptionField.getStyleClass().add((Object)"description");
        this.descriptionField.setMaxWidth(Double.MAX_VALUE);
        this.descriptionField.setText("...");
        this.descriptionField.textProperty().addListener((o, ov, nv) -> this.descriptionField.setTooltip(new Tooltip(nv)));
        HBox.setHgrow((Node)this.descriptionField, (Priority)Priority.ALWAYS);
        HBox box = new HBox(5.0);
        box.getChildren().addAll((Object[])new Node[]{this.valueField, this.descriptionField});
        this.getChildren().add((Object)box);
        this.focusedProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.valueField.requestFocus();
            }
        });
        this.setConverter(this.createStringConverter(desc));
        this.valueField.setOnKeyPressed(this.createKeyEventHandler(desc));
        ValidationUtils.install((Node)this.valueField, (Validator)this.createValidator(desc), (ValidationMode)ValidationMode.ON_DEMAND);
    }

    public void requestFocus() {
        this.valueField.requestFocus();
    }

    public ObservableValue<String> observableValue() {
        return this.valueProperty;
    }

    public String getValue() {
        return (String)this.valueProperty.get();
    }

    public void setValue(String value) {
        this.valueProperty.set((Object)value);
    }

    public ObjectProperty<String> valueProperty() {
        return this.valueProperty;
    }

    protected void layoutChildren() {
        this.prepareDecorations();
        super.layoutChildren();
        Platform.runLater(() -> this.layoutDecorations());
    }

    public void prepareDecorations() {
        if (this._operator == null) {
            this._operator = new DecorationDelegate((Region)this);
        }
        this._operator.prepareDecorations();
    }

    public void layoutDecorations() {
        this._operator.layoutDecorations();
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void positionInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, HPos halignment, VPos valignment) {
        super.positionInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, halignment, valignment);
    }

    public void setConverter(StringConverter<String> strConverter) {
        this.converter = strConverter;
        this.valueProperty.addListener((o, ov, nv) -> {
            if (!this.editCommitted) {
                this.valueField.setText(this.converter.toString(nv));
            }
        });
        this.valueField.textProperty().addListener((o, ov, nv) -> {
            boolean bl = this.editCommitted = false;
        });
    }

    private StringConverter<String> createStringConverter(EFormDescriptor.EFormFieldDescriptor desc) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Optional<AbstractEntity> getResource(EFormDescriptor.EFormFieldDescriptor desc) {
        ReferenceDescriptor refDesc = ReferenceDescriptor.of((String)desc.getFormat());
        RepositoryFX repo = this.repoCtx.getRepositoryFX(refDesc.getRepoDiscriminated());
        Resources resources = this.restClient.getResources(repo.getSearchLink("code"), AbstractEntity.class, new Params().param("d", (Object)ReferenceDescriptor.of((String)desc.getFormat()).getDiscriminator()).param("c", (Object)this.valueField.getText()));
        if (resources.getContent().size() > 0) {
            return resources.getContent().stream().findFirst();
        }
        return Optional.empty();
    }

    private EventHandler<? super KeyEvent> createKeyEventHandler(EFormDescriptor.EFormFieldDescriptor desc) {
        return event -> {
            if (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.TAB) {
                if (this.valueField.getText().equals("+")) {
                    this.valueField.setText("");
                    this.openBrowser(desc);
                } else if (this.valueField.getText().equals("")) {
                    if (desc.isRequired()) {
                        this.setValue("");
                        this.openBrowser(desc);
                    } else {
                        this.setValue("");
                        this.descriptionField.setText("");
                    }
                } else {
                    this.commitEdit();
                    ValidationUtils.validateOnDemand((Node)this);
                }
            }
        };
    }

    private Validator createValidator(EFormDescriptor.EFormFieldDescriptor desc) {
        return vo -> {
            if (vo.getNewValue().equals("+")) {
                return ValidationEvent.OK;
            }
            if (StringUtils.isEmpty((CharSequence)((String)vo.getNewValue()))) {
                if (!desc.isRequired()) {
                    return ValidationEvent.OK;
                }
                return new ValidationEvent(ValidationEvent.VALIDATION_ERROR);
            }
            Optional r = this.getResource(desc);
            if (!r.isPresent()) {
                Platform.runLater(() -> ((TextField)this.valueField).requestFocus());
                return new ValidationEvent(ValidationEvent.VALIDATION_ERROR);
            }
            if (this.getValue() == null) {
                return new ValidationEvent(ValidationEvent.VALIDATION_ERROR);
            }
            if (!this.getValue().equals(((AbstractEntity)r.get()).getLink("self").getHref())) {
                this.setValue(((AbstractEntity)r.get()).getLink("self").getHref());
            }
            return ValidationEvent.OK;
        };
    }

    private void openBrowser(EFormDescriptor.EFormFieldDescriptor desc) {
        String browserId = ReferenceDescriptor.of((String)desc.getFormat()).getRepoDiscriminated();
        this.uiCommands.openBrowser(browserId).withOutput(this.output).onCommit(c -> {
            AbstractEntity committed = c.getCommittedResource();
            this.valueProperty.set((Object)committed.getId().getHref());
            this.valueField.setText(committed.getCode());
            String text = EntityDescriptor.of((String)committed.getDescription()).getInlineDescription();
            this.descriptionField.setText(text);
            this.uiCommands.popContent().execute();
            ValidationUtils.validateOnDemand((Node)this);
        }).execute();
    }

    public void commitEdit() {
        this.editCommitted = true;
        this.setValue((String)this.converter.fromString(this.valueField.getText()));
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    static /* synthetic */ RestClient access$2(ReferenceTextField referenceTextField) {
        return referenceTextField.restClient;
    }

    static /* synthetic */ Button access$3(ReferenceTextField referenceTextField) {
        return referenceTextField.descriptionField;
    }

    static /* synthetic */ Optional access$4(ReferenceTextField referenceTextField, EFormDescriptor.EFormFieldDescriptor eFormFieldDescriptor) {
        return referenceTextField.getResource(eFormFieldDescriptor);
    }
}

