/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.factory.form.controller;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.Iterator;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.custom.factory.form.controller.FormFieldControllerBuilder;

public class FormFieldControllerFactory {
    private AutowireCapableBeanFactory factory;

    public FormFieldControllerFactory(AutowireCapableBeanFactory factory) {
        this.factory = factory;
    }

    private void injectDependencies(FormFieldControllerBuilder builder) {
        if (builder == null) {
            return;
        }
        this.factory.autowireBean((Object)builder);
        if (builder.getChildern() != null) {
            builder.getChildern().stream().forEach(b -> this.injectDependencies(b));
        }
    }

    private FormFieldController create(FormFieldControllerBuilder builder, EFormDescriptor.EFormFieldDescriptor d) {
        this.injectDependencies(builder);
        FormFieldController controller = null;
        if (builder.getChildern() == null) {
            if (builder.supportsType(d.getType()) && builder.suppportsDisplayFormat(d.getFormat())) {
                controller = builder.createControl(d);
            }
            return controller;
        }
        Iterator iterator = builder.getChildern().iterator();
        while (iterator.hasNext() && controller == null) {
            FormFieldControllerBuilder tmp = (FormFieldControllerBuilder)iterator.next();
            controller = this.create(tmp, d);
        }
        return controller;
    }

    public FormFieldController createController(FormFieldControllerBuilder builder, EFormDescriptor.EFormFieldDescriptor d) {
        FormFieldController controller = this.create(builder, d);
        if (controller == null) {
            controller = new FormFieldController((Control)new Label(String.format("No factory found", d.getFieldId())));
            controller.setBind(bind -> bind.bind((ObservableValue)new SimpleStringProperty("")));
        }
        this.decorate(controller.getControl(), d);
        controller.getControl().setId(d.getFieldId());
        return controller;
    }

    private void decorate(Control control, EFormDescriptor.EFormFieldDescriptor d) {
        if (d.isRequired()) {
            FontAwesomeIconView lblRequired = new FontAwesomeIconView(FontAwesomeIcon.ASTERISK);
            Decorator decRequired = new Decorator((Node)lblRequired, Pos.CENTER_RIGHT);
            DecorationUtils.install((Node)control, (Decorator)decRequired);
        }
    }
}

