/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.factory.form.reader;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.StringProperty;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.beans.EntityLink;
import rs.tetrabyte.pezar.beans.annotations.RestLink;
import rs.tetrabyte.pezar.beans.annotations.RestReference;
import rs.tetrabyte.pezar.custom.factory.form.reader.ObjectReader;

public class EntityReader<T extends AbstractEntity>
implements ObjectReader<T> {
    private RestClient client;

    public EntityReader(RestClient client) {
        this.client = client;
    }

    public List<ObjectReader.Field> readFields(AbstractEntity resource) {
        AbstractEntity object = resource;
        ArrayList<ObjectReader.Field> fields = new ArrayList<ObjectReader.Field>();
        Field[] flds = FieldUtils.getAllFields(object.getClass());
        int i = 0;
        while (i < flds.length) {
            Field fld = flds[i];
            fld.setAccessible(true);
            String name = fld.getName();
            try {
                Object value = fld.get(object);
                if (value instanceof StringProperty) {
                    StringProperty prop = (StringProperty)value;
                    if (fld.getAnnotation(RestReference.class) != null) {
                        Resource refResource;
                        Link refLink;
                        String rel = fld.getAnnotation(RestReference.class).rel();
                        if (StringUtils.isEmpty((CharSequence)rel)) {
                            rel = name;
                        }
                        if ((refLink = resource.getLink(name)) != null && (refResource = this.client.getResource(refLink)) != null) {
                            Link realLink = refResource.getLink("self");
                            prop.set((Object)realLink.getHref());
                        }
                    }
                    fields.add(new ObjectReader.Field(name, prop));
                } else if (fld.getAnnotation(RestLink.class) != null && fld.get(resource) instanceof List) {
                    List links = (List)fld.get(resource);
                    for (Object l : links) {
                        Resource refResource;
                        if (!(l instanceof EntityLink)) continue;
                        EntityLink link = (EntityLink)l;
                        StringProperty prop = link.referenceProperty();
                        Link refLink = link.getLink("reference");
                        if (refLink != null && (refResource = this.client.getResource(refLink)) != null) {
                            Link realLink = refResource.getLink("self");
                            prop.set((Object)realLink.getHref());
                        }
                        fields.add(new ObjectReader.Field(String.valueOf(fld.getAnnotation(RestLink.class).name()) + "-" + link.getDiscriminator(), prop));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fld.setAccessible(false);
            ++i;
        }
        if (object.getAttributes() != null && object.getAttributes().size() > 0) {
            object.getAttributes().stream().forEach(a -> fields.add(new ObjectReader.Field(a.getName(), a.valueProperty())));
        }
        return fields;
    }
}

