/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.factory.field.form;

import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import jidefx.scene.control.editor.ComboBoxEditor;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.factory.field.form.FormFieldFactory;
import rs.tetrabyte.pezar.factory.field.util.ValueObject;

public class FormComboBoxFactory
implements FormFieldFactory {
    private ChangeListener<ValueObject> changeListener;

    public boolean supportsType(String type) {
        return type.equals("option");
    }

    public boolean suppportsDisplayFormat(String displayFormat) {
        return true;
    }

    public boolean supportsMultipleValues() {
        return true;
    }

    public FormFieldController createControl(EFormDescriptor.EFormFieldDescriptor d) {
        ComboBoxEditor cb = new ComboBoxEditor();
        if (d.getValues() != null && d.getValues().size() > 0) {
            cb.getItems().addAll((Collection)d.getValues().stream().map(v -> new ValueObject(v.getValue(), v.getLabel())).collect(Collectors.toList()));
        }
        if (d.isRequired()) {
            ValidationUtils.install((Node)cb, (Validator)this.createValidator(), (ValidationMode)ValidationMode.ON_DEMAND);
        }
        FormFieldController c = new FormFieldController((Control)cb);
        c.setBind(p -> this.bind((ComboBox)cb, p));
        c.setUnBind(p -> this.unBind(cb));
        return c;
    }

    private Validator createValidator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void bind(ComboBox<ValueObject> cb, StringProperty prop) {
        cb.getSelectionModel().select((Object)new ValueObject(prop.getValue().toString(), ""));
        this.changeListener = new /* Unavailable Anonymous Inner Class!! */;
        cb.valueProperty().addListener(this.changeListener);
    }

    private void unBind(ComboBoxEditor<ValueObject> cb) {
        cb.valueProperty().removeListener(this.changeListener);
    }
}

