/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.factory.field.form;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.util.StringConverter;
import jidefx.scene.control.field.NumberField;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.factory.field.form.FormFieldFactory;

public class FormDecimalFieldFactory
implements FormFieldFactory {
    private ChangeListener<Number> changeListener;

    public boolean supportsType(String type) {
        if (type == null) {
            return false;
        }
        return "decimal".equals(type);
    }

    public boolean suppportsDisplayFormat(String displayFormat) {
        return true;
    }

    public boolean supportsMultipleValues() {
        return false;
    }

    public FormFieldController createControl(EFormDescriptor.EFormFieldDescriptor d) {
        NumberField nf = new NumberField();
        nf.setNumberType(NumberField.NumberType.Normal);
        if (!StringUtils.isEmpty((CharSequence)d.getFormat())) {
            DecimalFormat df = new DecimalFormat(d.getFormat());
            df.setParseBigDecimal(true);
            nf.setDecimalFormat(df);
        }
        nf.setValue((Object)new BigDecimal(0));
        nf.setAlignment(Pos.BASELINE_RIGHT);
        nf.setSpinnersVisible(false);
        nf.getPatternVerifiers().put((Object)"n", (Object)new /* Unavailable Anonymous Inner Class!! */);
        nf.getPatternVerifiers().put((Object)"f", (Object)new /* Unavailable Anonymous Inner Class!! */);
        FormFieldController c = new FormFieldController((Control)nf);
        c.setBind(p -> this.bind(nf, p));
        c.setUnBind(p -> this.unBind(nf));
        if (!StringUtils.isEmpty((CharSequence)d.getValidationPattern())) {
            ValidationUtils.install((Node)nf, (Validator)this.createValidator(d), (ValidationMode)ValidationMode.ON_FLY);
        }
        if (d.isRequired()) {
            ValidationUtils.install((Node)nf, (Validator)this.createValidator(d), (ValidationMode)ValidationMode.ON_DEMAND);
        }
        return c;
    }

    private Validator createValidator(EFormDescriptor.EFormFieldDescriptor d) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void bind(NumberField nf, StringProperty prop) {
        nf.setStringConverter((StringConverter)new /* Unavailable Anonymous Inner Class!! */);
        String value = prop.getValue();
        if (value != null) {
            try {
                nf.setValue((Object)nf.getDecimalFormat().parse(value));
            }
            catch (ParseException e) {
                nf.setValue((Object)BigDecimal.ZERO);
            }
        }
        this.changeListener = new /* Unavailable Anonymous Inner Class!! */;
        nf.valueProperty().addListener(this.changeListener);
    }

    private void unBind(NumberField nf) {
        nf.valueProperty().removeListener(this.changeListener);
    }
}

