/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.features;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javafx.event.EventHandler;
import javafx.scene.Node;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.pezar.features.UIFeature;
import rs.tetrabyte.pezar.features.UIFeatureDefault;
import rs.tetrabyte.pezar.features.event.UIEvent;

public class UIFeatureBuilder {
    private String id;
    private String label;
    private Supplier<Node> graphic;
    private EventHandler<UIEvent> eventHandler;
    private List<UIFeatureBuilder> children;
    private UIFeatureBuilder parent;
    private LocaleContext localeCtx;

    public UIFeatureBuilder(LocaleContext localeCtx) {
        this.localeCtx = localeCtx;
    }

    public UIFeatureBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public UIFeatureBuilder withLabel(String label) {
        this.label = label;
        return this;
    }

    public UIFeatureBuilder withGraphic(Supplier<Node> graphic) {
        this.graphic = graphic;
        return this;
    }

    public UIFeatureBuilder withGlyph(String code) {
        this.graphic = () -> GlyphFactory.createGlyph((String)code);
        return this;
    }

    UIFeatureBuilder withGlyph(FontAwesomeIcon icon) {
        this.graphic = () -> new FontAwesomeIconView(icon);
        return this;
    }

    public UIFeatureBuilder withAction(EventHandler<UIEvent> action) {
        this.eventHandler = action;
        return this;
    }

    private UIFeatureBuilder withParent(UIFeatureBuilder parent) {
        this.parent = parent;
        return this;
    }

    public UIFeatureBuilder createChild() {
        return new UIFeatureBuilder(this.localeCtx).withParent(this);
    }

    public UIFeatureBuilder add() {
        if (this.parent == null) {
            throw new RuntimeException("Can't call 'add()' on builder that doesn't have parent");
        }
        if (this.parent.children == null) {
            this.parent.children = new ArrayList();
        }
        this.parent.children.add(this);
        return this.parent;
    }

    public UIFeature build() {
        UIFeatureDefault feature = new UIFeatureDefault(this.id, this.label.startsWith("%") ? this.localeCtx.getMessage(this.label.substring(1), new Object[0]) : this.label, this.parent != null ? this.parent.id : null, this.graphic);
        feature.setOnAction(this.eventHandler);
        if (this.children != null) {
            this.children.forEach(c -> feature.getChildren().add(c.build()));
        }
        return feature;
    }
}

