/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.websocket;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import rs.tetrabyte.pezar.websocket.StompSessionHandlerImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class StompSessionHandlerImpl
implements StompSessionHandler {
    private static final Logger logger = LoggerFactory.getLogger(StompSessionHandlerImpl.class);
    private Map<String, WebSocketDestination<?>> destinations = new HashMap();
    private StompSession session;
    private Object url;
    private Runnable onConnected;
    private Runnable onConnectionLost;

    public StompSessionHandlerImpl(String url) {
        this.url = url;
    }

    public void handleFrame(StompHeaders headers, Object payload) {
        if (headers.containsKey((Object)"sender-session") && ((String)headers.get((Object)"sender-session").get(0)).equals(this.session.getSessionId())) {
            logger.debug("Dropping own message: " + payload);
            return;
        }
        if (this.destinations.containsKey(headers.getDestination())) {
            WebSocketDestination.access$1((WebSocketDestination)((WebSocketDestination)this.destinations.get(headers.getDestination()))).ifPresent(s -> {
                WebSocketDestination.WebSocketSubscription.access$1((WebSocketDestination.WebSocketSubscription)s).ifPresent(c -> {
                    logger.debug("Message accepted: " + payload + " Headers: " + headers);
                    Platform.runLater(() -> c.accept(payload));
                });
                if (!WebSocketDestination.WebSocketSubscription.access$1((WebSocketDestination.WebSocketSubscription)s).isPresent()) {
                    logger.debug("Message received, but rejected. Reason: No consumer found");
                }
            });
            if (!WebSocketDestination.access$1((WebSocketDestination)((WebSocketDestination)this.destinations.get(headers.getDestination()))).isPresent()) {
                logger.debug("Message received, but rejected. Reason: No subscription found");
            }
        } else {
            logger.debug("Message received, but rejected. Reason: Destination not registered '{}'", (Object)headers.getDestination());
        }
    }

    public Type getPayloadType(StompHeaders headers) {
        WebSocketDestination destination = (WebSocketDestination)this.destinations.get(headers.getDestination());
        if (destination != null && WebSocketDestination.access$1((WebSocketDestination)destination).isPresent()) {
            return WebSocketDestination.WebSocketSubscription.access$2((WebSocketDestination.WebSocketSubscription)((WebSocketDestination.WebSocketSubscription)WebSocketDestination.access$1((WebSocketDestination)destination).get()));
        }
        logger.error("Can't deserialize message. Unknown type. Headers: " + headers.toString());
        return Object.class;
    }

    public void handleTransportError(StompSession session, Throwable exception) {
        logger.error("Message transport error", exception);
        if (this.onConnectionLost != null) {
            Platform.runLater(() -> this.onConnectionLost.run());
        }
    }

    public void handleException(StompSession session, StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
        logger.error("WebSocket exception", exception);
    }

    public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
        logger.info("WebSocket connection established: {}", this.url);
        this.session = session;
        this.destinations.entrySet().forEach(e -> WebSocketDestination.access$2((WebSocketDestination)((WebSocketDestination)e.getValue())));
        if (this.onConnected != null) {
            Platform.runLater(() -> this.onConnected.run());
        }
    }

    public void disconnectSession() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
            logger.info("WebSocket session disconnected: " + this.url);
        }
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public void send(String destination, Object payload) {
        StompHeaders headers = new StompHeaders();
        headers.setDestination(destination);
        headers.add("sender-session", this.session.getSessionId());
        logger.debug("Sending message: " + payload + " Headers: " + headers);
        this.session.send(headers, payload);
    }

    public <T> WebSocketDestination<T> registerDestination(String dest, Class<T> payloadClass) {
        WebSocketDestination destination = new WebSocketDestination(this, dest, payloadClass, null);
        this.destinations.put(dest, destination);
        return destination;
    }

    public void unregisterDestination(String dest) {
        if (this.destinations.containsKey(dest)) {
            WebSocketDestination destination = (WebSocketDestination)this.destinations.get(dest);
            WebSocketDestination.access$1((WebSocketDestination)destination).ifPresent(s -> s.unSubscribe());
            this.destinations.remove(dest);
        }
    }

    public void setOnConnected(Runnable run) {
        this.onConnected = run;
    }

    public void setOnConnectionLost(Runnable run) {
        this.onConnectionLost = run;
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ StompSession access$1(StompSessionHandlerImpl stompSessionHandlerImpl) {
        return stompSessionHandlerImpl.session;
    }
}

